/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.blocks;

import com.aetherteam.aether.block.AetherBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class AmbrosiumLampBlock
extends ZetaBlock {
    public static final IntegerProperty LIGHT = BlockStateProperties.f_61389_;

    public AmbrosiumLampBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && !AmbrosiumLampBlock.isRespawnFuel(itemstack) && AmbrosiumLampBlock.isRespawnFuel(player.m_21120_(InteractionHand.OFF_HAND))) {
            return InteractionResult.PASS;
        }
        if (AmbrosiumLampBlock.isRespawnFuel(itemstack) && AmbrosiumLampBlock.canBeCharged(blockState)) {
            AmbrosiumLampBlock.charge(level, blockPos, blockState);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!AmbrosiumLampBlock.isRespawnFuel(itemstack) && AmbrosiumLampBlock.isOn(blockState) && itemstack.m_41619_()) {
            AmbrosiumLampBlock.deplete(level, blockPos, blockState);
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)((Block)AetherBlocks.AMBROSIUM_BLOCK.get()).m_5456_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static boolean isRespawnFuel(ItemStack itemStack) {
        return itemStack.m_150930_(((Block)AetherBlocks.AMBROSIUM_BLOCK.get()).m_5456_());
    }

    private static boolean canBeCharged(BlockState value) {
        return (Integer)value.m_61143_((Property)LIGHT) < 4;
    }

    public static void charge(Level level, BlockPos blockPos, BlockState blockState) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)LIGHT) + 1)), 3);
        level.m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void deplete(Level level, BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.m_61143_((Property)LIGHT) > 0) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)LIGHT) - 1)), 3);
        }
        level.m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> add) {
        add.m_61104_(new Property[]{LIGHT});
    }

    private static boolean isOn(BlockState value) {
        return (Integer)value.m_61143_((Property)LIGHT) > 0;
    }

    public static int getScaledChargeLevel(BlockState blockState, int i) {
        return Mth.m_14143_((float)((float)((Integer)blockState.m_61143_((Property)LIGHT)).intValue() / 4.0f * (float)i));
    }
}

