/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark.blocks;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.razordevs.ascended_quark.entity.AQStool;
import org.razordevs.ascended_quark.module.SkyrootStoolModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class AQStoolBlock
extends ZetaBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_TOP_BIG = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG_BIG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG, SHAPE_LEG.m_83216_(0.75, 0.0, 0.0), SHAPE_LEG.m_83216_(0.75, 0.0, 0.75), SHAPE_LEG.m_83216_(0.0, 0.0, 0.75)});
    private static final VoxelShape SHAPE_BIG = Shapes.m_83124_((VoxelShape)SHAPE_TOP_BIG, (VoxelShape[])new VoxelShape[]{SHAPE_LEG_BIG, SHAPE_LEG_BIG.m_83216_(0.75, 0.0, 0.0), SHAPE_LEG_BIG.m_83216_(0.75, 0.0, 0.75), SHAPE_LEG_BIG.m_83216_(0.0, 0.0, 0.75)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty BIG = BooleanProperty.m_61465_((String)"big");
    public static final BooleanProperty SAT_IN = BooleanProperty.m_61465_((String)"sat_in");

    public AQStoolBlock(String name, ZetaModule module) {
        super(name, module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BIG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(false)));
    }

    public void blockClicked(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)BIG)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BIG, (Comparable)Boolean.valueOf(true)));
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        this.fixState((Level)worldIn, pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)SAT_IN)).booleanValue() || !worldIn.m_8055_(pos.m_7494_()).m_60795_() || player.m_20202_() != null) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        if (!worldIn.f_46443_) {
            AQStool entity = new AQStool(SkyrootStoolModule.stoolEntity, worldIn);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5);
            worldIn.m_7967_((Entity)entity);
            player.m_20329_((Entity)entity);
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(true)));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142072_(@Nonnull Level worldIn, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance * 0.5f);
    }

    public void m_5548_(@Nonnull BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(worldIn, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * (double)0.66f * d0, vector3d.f_82481_);
        }
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)BIG) != false ? SHAPE_BIG : SHAPE;
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateFor(context.m_43725_(), context.m_8083_());
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.fixState(worldIn, pos, state);
    }

    private void fixState(Level worldIn, BlockPos pos, BlockState state) {
        BlockState target = this.getStateFor(worldIn, pos);
        if (!target.equals(state)) {
            worldIn.m_46597_(pos, target);
        }
    }

    private BlockState getStateFor(Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)BIG, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7494_()).m_60808_((BlockGetter)world, pos.m_7494_()).m_83288_(Direction.Axis.Y) == 0.0))).m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(world.m_6443_(AQStool.class, new AABB(pos, pos.m_7494_()).m_82400_(0.4), e -> e.m_20183_().equals((Object)pos)).size() > 0));
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, @Nonnull Level worldIn, @Nonnull BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)SAT_IN) != false ? 15 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, BIG, SAT_IN});
    }
}

