/*
 * Decompiled with CFR 0.152.
 */
package org.razordevs.ascended_quark;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.razordevs.ascended_quark.datagen.AQBlockstateData;
import org.razordevs.ascended_quark.datagen.AQItemModelData;
import org.razordevs.ascended_quark.datagen.AQLangData;
import org.razordevs.ascended_quark.datagen.AQRecipeData;
import org.razordevs.ascended_quark.datagen.loot.AQLootTableData;
import org.razordevs.ascended_quark.datagen.loot.modifiers.AQGlobalLootModifiers;
import org.razordevs.ascended_quark.datagen.loot.modifiers.AQLootDataProvider;
import org.razordevs.ascended_quark.datagen.tags.AQBlockTagData;
import org.razordevs.ascended_quark.datagen.tags.AQItemTagData;
import org.razordevs.ascended_quark.mixin.ZetaRegistryAccessor;
import org.razordevs.ascended_quark.proxy.ACClientProxy;
import org.razordevs.ascended_quark.proxy.ACCommonProxy;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.multiloader.Env;
import org.violetmoon.zetaimplforge.ForgeZeta;

@Mod(value="ascended_quark")
public class AscendedQuark {
    public static final String MODID = "ascended_quark";
    public static final String AETHER = "aether";
    public static final String DEEP_AETHER = "deep_aether";
    public static final Logger LOGGER = LogManager.getLogger((String)"ascended_quark");
    public static AscendedQuark instance;
    public static ACCommonProxy proxy;
    public static final Zeta ZETA;

    public AscendedQuark() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        instance = this;
        ZETA.start();
        proxy = (ACCommonProxy)Env.unsafeRunForDist(() -> ACClientProxy::new, () -> ACCommonProxy::new);
        proxy.start();
        MinecraftForge.EVENT_BUS.addListener(this::missingMappings);
        bus.addListener(this::dataSetup);
        AQGlobalLootModifiers.LOOT_MODIFIERS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void dataSetup(GatherDataEvent event) {
        ZetaRegistryAccessor accessor = (ZetaRegistryAccessor)AscendedQuark.ZETA.registry;
        HashMap<String, Block> blockMap = new HashMap<String, Block>();
        HashMap<String, Item> itemBlockMap = new HashMap<String, Item>();
        HashMap<String, Item> itemMap = new HashMap<String, Item>();
        for (Object value : accessor.getInternalNames().keySet()) {
            ResourceLocation location = accessor.getInternalNames().get(value);
            if (value instanceof Block) {
                Block block = (Block)value;
                blockMap.put(location.m_135815_(), block);
                continue;
            }
            if (!(value instanceof Item)) continue;
            Item item2 = (Item)value;
            itemBlockMap.put(location.m_135815_(), item2);
        }
        itemBlockMap.forEach((s, item) -> {
            if (!blockMap.containsKey(s)) {
                itemMap.put((String)s, (Item)item);
            }
        });
        itemBlockMap.clear();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new AQBlockstateData(output, fileHelper, blockMap));
        generator.addProvider(event.includeClient(), (DataProvider)new AQItemModelData(output, fileHelper, itemMap, blockMap));
        generator.addProvider(event.includeClient(), (DataProvider)new AQLangData(output, itemMap, blockMap));
        generator.addProvider(event.includeServer(), (DataProvider)new AQRecipeData(output, itemMap, blockMap));
        generator.addProvider(event.includeServer(), (DataProvider)AQLootTableData.create(output, blockMap));
        AQBlockTagData blockTags = new AQBlockTagData(output, lookupProvider, fileHelper, blockMap);
        generator.addProvider(event.includeServer(), (DataProvider)new AQLootDataProvider(output, itemMap));
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new AQItemTagData(output, lookupProvider, blockTags.m_274426_(), fileHelper, itemMap, blockMap));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.1")
    public void missingMappings(MissingMappingsEvent event) {
        Stream stream = event.getMappings(ForgeRegistries.Keys.BLOCKS, MODID).stream();
        stream.filter(mapping -> mapping.getKey().m_135815_().contains("brick_")).forEach(blockMapping -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(AscendedQuark.asResource(blockMapping.getKey().m_135815_().replace("brick_", "bricks_")));
            if (block != null) {
                blockMapping.remap((Object)block);
            }
        });
        Stream itemSteam = event.getMappings(ForgeRegistries.Keys.ITEMS, MODID).stream();
        itemSteam.filter(mapping -> mapping.getKey().m_135815_().contains("brick_")).forEach(itemMapping -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(AscendedQuark.asResource(itemMapping.getKey().m_135815_().replace("brick_", "bricks_")));
            if (block != null) {
                itemMapping.remap((Object)block.m_5456_());
            }
        });
    }

    public static ResourceLocation asResource(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static <T> ResourceKey<T> asResourceKey(ResourceKey<? extends Registry<T>> base, String name) {
        return ResourceKey.m_135785_(base, (ResourceLocation)AscendedQuark.asResource(name));
    }

    static {
        ZETA = new ForgeZeta(MODID, LogManager.getLogger((String)"aq-zeta"));
    }
}

