/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class SnowTreeFeature
extends Feature<TreeConfiguration> {
    public SnowTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    private static boolean isVine(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60713_(Blocks.f_50191_));
    }

    private static void setBlockKnownShape(LevelWriter p_67257_, BlockPos p_67258_, BlockState p_67259_) {
        p_67257_.m_7731_(p_67258_, p_67259_, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_278411_));
    }

    private boolean doPlace(WorldGenLevel level, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, BiConsumer<BlockPos, BlockState> consumer1, FoliagePlacer.FoliageSetter setter, TreeConfiguration config) {
        int i = config.f_68190_.m_226153_(random);
        int j = config.f_68189_.m_214116_(random, i, config);
        int k = i - j;
        int l = config.f_68189_.m_214117_(random, k);
        BlockPos blockpos = config.f_225455_.map(p_225286_ -> p_225286_.m_225891_(pos, random)).orElse(pos);
        int i1 = Math.min(pos.m_123342_(), blockpos.m_123342_());
        int j1 = Math.max(pos.m_123342_(), blockpos.m_123342_()) + i + 1;
        if (i1 >= level.m_141937_() + 1 && j1 <= level.m_151558_()) {
            OptionalInt optionalint = config.f_68191_.m_68295_();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, blockpos, config);
            if (k1 >= i || optionalint.isPresent() && k1 >= optionalint.getAsInt()) {
                if (config.f_225455_.isPresent() && !((RootPlacer)config.f_225455_.get()).m_213684_((LevelSimulatedReader)level, consumer, random, pos, blockpos, config)) {
                    return false;
                }
                List list = config.f_68190_.m_213934_((LevelSimulatedReader)level, consumer1, random, k1, blockpos, config);
                list.forEach(p_225279_ -> config.f_68189_.m_271927_((LevelSimulatedReader)level, setter, random, config, k1, p_225279_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader reader, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.f_68191_.m_6133_(height, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)pos, k, i, l);
                    if (config.f_68190_.m_226184_(reader, (BlockPos)blockpos$mutableblockpos) && (config.f_68193_ || !SnowTreeFeature.isVine(reader, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    protected void m_5974_(LevelWriter writer, BlockPos pos, BlockState state) {
        SnowTreeFeature.setBlockKnownShape(writer, pos, state);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        final WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        BlockPos blockpos = context.m_159777_();
        TreeConfiguration treeconfiguration = (TreeConfiguration)context.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.m_7949_());
            worldgenlevel.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.m_7949_());
            worldgenlevel.m_7731_(p_160548_, p_160549_, 19);
        };
        FoliagePlacer.FoliageSetter setter = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos pos, BlockState state) {
                set2.add(pos.m_7949_());
                worldgenlevel.m_7731_(pos, state, 19);
            }

            public boolean m_271808_(BlockPos p_272999_) {
                return set2.contains(p_272999_);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
            set3.add(p_225290_.m_7949_());
            worldgenlevel.m_7731_(p_225290_, p_225291_, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, setter, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.f_68187_.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.f_68187_.forEach(p_225282_ -> p_225282_.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_225270_ -> {
                DiscreteVoxelShape discretevoxelshape = SnowTreeFeature.updateLeaves((LevelAccessor)worldgenlevel, p_225270_, set1, set3, set);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)p_225270_.m_162395_(), (int)p_225270_.m_162396_(), (int)p_225270_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static DiscreteVoxelShape updateLeaves(LevelAccessor accessor, BoundingBox box, Set<BlockPos> posSet, Set<BlockPos> posSet1, Set<BlockPos> posSet2) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(box.m_71056_(), box.m_71057_(), box.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList((Iterable)Sets.union(posSet1, posSet2))) {
            if (!box.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - box.m_162395_(), blockpos.m_123342_() - box.m_162396_(), blockpos.m_123343_() - box.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(posSet)) {
            if (box.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - box.m_162395_(), blockpos1.m_123342_() - box.m_162396_(), blockpos1.m_123343_() - box.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (posSet.contains(blockpos$mutableblockpos) || !(blockstate = accessor.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                SnowTreeFeature.setBlockKnownShape((LevelWriter)accessor, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!box.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - box.m_162395_(), blockpos$mutableblockpos.m_123342_() - box.m_162396_(), blockpos$mutableblockpos.m_123343_() - box.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (box.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - box.m_162395_(), blockpos2.m_123342_() - box.m_162396_(), blockpos2.m_123343_() - box.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = accessor.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    SnowTreeFeature.setBlockKnownShape((LevelWriter)accessor, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (box.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - box.m_162395_(), blockpos$mutableblockpos.m_123342_() - box.m_162396_(), blockpos$mutableblockpos.m_123343_() - box.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

