/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import com.google.common.collect.Maps;
import fuzs.stoneworks.Stoneworks;
import fuzs.stoneworks.config.CommonConfig;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class StoneVariantsProvider {
    private static final Map<String, StoneBlockVariant> STONE_BLOCK_VARIANTS = Maps.newLinkedHashMap();
    @Nullable
    private static Collection<ItemStack> sortedVariantItems;

    public static void invalidateItems() {
        sortedVariantItems = null;
    }

    public static Stream<StoneBlockVariant> getAllStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream();
    }

    public static Stream<StoneBlockVariant> getStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream().filter(Predicate.not(StoneBlockVariant::isVanillaVariant));
    }

    public static ItemStack[] getDisplayItemStacks() {
        return (ItemStack[])StoneVariantsProvider.getAllStoneBlockVariants().filter(variant -> variant.blockVariant() == BlockVariant.REGULAR).map(StoneBlockVariant::block).map(ItemStack::new).toArray(ItemStack[]::new);
    }

    public static Collection<ItemStack> getSortedVariantItems() {
        if (sortedVariantItems == null) {
            Stream<StoneBlockVariant> stream = ((CommonConfig)Stoneworks.CONFIG.get(CommonConfig.class)).vanillaVariantsInCreativeTab ? StoneVariantsProvider.getAllStoneBlockVariants() : StoneVariantsProvider.getStoneBlockVariants();
            sortedVariantItems = stream.sorted(Comparator.comparingInt(v -> v.stoneType().ordinal()).thenComparingInt(v -> v.blockVariant().ordinal())).flatMap(StoneBlockVariant::allBlocks).map(Block::m_5456_).map(ItemStack::new).toList();
        }
        return sortedVariantItems;
    }

    private static void registerAllStoneBlockVariants() {
        for (StoneType stoneType : StoneType.values()) {
            for (BlockVariant blockVariant : BlockVariant.values()) {
                StoneVariantsProvider.registerStoneBlockVariant(new StoneBlockVariant(stoneType, blockVariant), false);
            }
        }
    }

    private static void registerStoneBlockVariant(StoneBlockVariant variant, boolean replace) {
        if (STONE_BLOCK_VARIANTS.put(variant.name(), variant) == null && replace) {
            throw new IllegalStateException("unable to replace stone block variant %s".formatted(variant.name()));
        }
    }

    public static StoneBlockVariant getStoneVariant(StoneType stoneType, BlockVariant blockVariant) {
        return STONE_BLOCK_VARIANTS.get(blockVariant.getName(stoneType));
    }

    private static void registerVanillaOverrides() {
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.REGULAR, Blocks.f_50069_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.COBBLED, Blocks.f_50652_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_COBBLED, Blocks.f_50079_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.BRICKS, Blocks.f_50222_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_BRICKS, Blocks.f_50223_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CRACKED_BRICKS, Blocks.f_50224_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.POLISHED, Blocks.f_50470_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CHISELED, Blocks.f_50225_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.REGULAR, Blocks.f_50334_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.POLISHED, Blocks.f_50387_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.REGULAR, Blocks.f_50122_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.POLISHED, Blocks.f_50175_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.REGULAR, Blocks.f_50228_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.POLISHED, Blocks.f_50281_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.REGULAR, Blocks.f_152550_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.COBBLED, Blocks.f_152551_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.BRICKS, Blocks.f_152589_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_BRICKS, Blocks.f_152594_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.POLISHED, Blocks.f_152555_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CHISELED, Blocks.f_152593_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.TILES, Blocks.f_152559_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_TILES, Blocks.f_152595_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.CALCITE, BlockVariant.REGULAR, Blocks.f_152497_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.REGULAR, Blocks.f_152496_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.REGULAR, Blocks.f_50137_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.POLISHED, Blocks.f_152597_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.PILLAR, Blocks.f_50138_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.REGULAR, Blocks.f_50730_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.BRICKS, Blocks.f_50735_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CRACKED_BRICKS, Blocks.f_50736_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.POLISHED, Blocks.f_50734_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CHISELED, Blocks.f_50737_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.REGULAR, Blocks.f_50134_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CHISELED, Blocks.f_50712_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.TILES, Blocks.f_50197_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CRACKED_TILES, Blocks.f_50713_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.REGULAR, Blocks.f_50259_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.BRICKS, Blocks.f_50443_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PLATES, Blocks.f_50492_, Blocks.f_50442_, Blocks.f_50469_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PILLAR, Blocks.f_50441_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.REGULAR, Blocks.f_50377_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.SHINGLES, Blocks.f_50378_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DARK_PRISMARINE, BlockVariant.PAVERS, Blocks.f_50379_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.REGULAR, Blocks.f_50062_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.POLISHED, Blocks.f_50064_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.CHISELED, Blocks.f_50063_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.REGULAR, Blocks.f_50394_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.POLISHED, Blocks.f_50396_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.CHISELED, Blocks.f_50395_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.REGULAR, Blocks.f_50333_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.BRICKS, Blocks.f_50714_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.CHISELED, Blocks.f_50282_);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.PILLAR, Blocks.f_50283_);
    }

    private static void registerVanillaOverride(StoneType stoneType, BlockVariant blockVariant, Block ... blocks) {
        StoneVariantsProvider.registerStoneBlockVariant(new VanillaStoneBlockVariant(stoneType, blockVariant, blocks), true);
    }

    static {
        StoneVariantsProvider.registerAllStoneBlockVariants();
        StoneVariantsProvider.registerVanillaOverrides();
    }

    private static class VanillaStoneBlockVariant
    extends StoneBlockVariant {
        private final String block;
        private final boolean deviates;

        VanillaStoneBlockVariant(StoneType stoneType, BlockVariant blockVariant, Block ... blocks) {
            super(stoneType, blockVariant, Arrays.copyOf(blocks, 4));
            if (blocks.length < 1 || blocks.length > 4) {
                throw new IllegalStateException("wrong number of blocks provided");
            }
            this.block = BuiltInRegistries.f_256975_.m_7981_((Object)blocks[0]).m_135815_();
            this.deviates = !this.blockName().equals(this.name());
        }

        @Override
        public String blockName() {
            return this.block;
        }

        @Override
        public String stairsName() {
            return this.deviates ? this.blockName() + "_stairs" : super.stairsName();
        }

        @Override
        public String slabName() {
            return this.deviates ? this.blockName() + "_slab" : super.slabName();
        }

        @Override
        public String wallName() {
            return this.deviates ? this.blockName() + "_wall" : super.wallName();
        }

        @Override
        public ResourceLocation id(String key) {
            return new ResourceLocation(key);
        }

        @Override
        public boolean isVanillaVariant() {
            return true;
        }
    }
}

