/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.registry.RaidedRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Inquisitor
extends AbstractIllager {
    private static final EntityDataAccessor<Integer> INQUISITOR_TYPE = SynchedEntityData.m_135353_(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Inquisitor(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new InquisitorMeleeAttackGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INQUISITOR_TYPE, (Object)0);
    }

    public int getInquisitorType() {
        return (Integer)this.f_19804_.m_135370_(INQUISITOR_TYPE);
    }

    public void setInquisitorType(int index) {
        this.f_19804_.m_135381_(INQUISITOR_TYPE, (Object)index);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("InquisitorType", this.getInquisitorType());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setInquisitorType(tag.m_128451_("InquisitorType"));
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasShield()) {
            Entity entity = source.m_7640_();
            return !(entity instanceof Projectile) ? super.m_6469_(source, amount) : false;
        }
        return super.m_6469_(source, amount);
    }

    private boolean hasShield() {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.OFFHAND);
        return itemstack.m_41720_() instanceof ShieldItem;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public void m_7895_(int wave, boolean unused) {
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public boolean m_7490_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return RaidedRegistry.INQUISITOR.getAmbient();
    }

    protected SoundEvent m_5592_() {
        return RaidedRegistry.INQUISITOR.getDeath();
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return RaidedRegistry.INQUISITOR.getHurt();
    }

    public SoundEvent m_7930_() {
        return RaidedRegistry.INQUISITOR.getCelebrate();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData spawngroupdata = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.setInquisitorType(this.f_19796_.m_188503_(3) + 1);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.m_213946_(this.f_19796_, difficultyInstance);
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * difficultyInstance.m_19057_());
        return spawngroupdata;
    }

    static class InquisitorMeleeAttackGoal
    extends MeleeAttackGoal {
        public InquisitorMeleeAttackGoal(Inquisitor inquisitor) {
            super((PathfinderMob)inquisitor, 1.0, false);
        }

        protected double m_6639_(LivingEntity livingEntity) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * f * 2.0f + livingEntity.m_20205_();
            }
            return super.m_6639_(livingEntity);
        }
    }
}

