/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips.foundation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import toni.immersivetips.ImmersiveTips;
import toni.immersivetips.api.CollectTips;
import toni.immersivetips.foundation.ImmersiveTip;
import toni.immersivetips.foundation.LegacyTip;
import toni.immersivetips.foundation.config.AllConfigs;
import toni.lib.utils.VersionUtils;

public class TipsResourceReloadListener
implements SimpleSynchronousResourceReloadListener {
    public static final Codec<LegacyTip> LEGACY_TIP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("translate").forGetter(tip -> tip.translate)).apply((Applicative)instance, LegacyTip::new));

    public ResourceLocation getFabricId() {
        return VersionUtils.resource((String)"immersivetips", (String)"tips");
    }

    public void m_6213_(ResourceManager manager) {
        ArrayList<ImmersiveTip> tips = new ArrayList<ImmersiveTip>();
        ImmersiveTips.LocalTips.clear();
        ((CollectTips)CollectTips.EVENT.invoker()).onCollectTips(new CollectTips.CollectTipsContext(tips));
        this.addDefaultTips(tips);
        ImmersiveTips.LocalTips.addAll(tips);
        Map resources = manager.m_214159_("tips", path -> true);
        for (ResourceLocation id : resources.keySet()) {
            try {
                InputStream stream = ((Resource)manager.m_213713_(id).get()).m_215507_();
                if (id.m_135827_().equals("immersivetips")) {
                    this.loadImmersiveTipList(id, stream);
                }
                if (!id.m_135827_().equals("tipsmod") || !((Boolean)AllConfigs.client().enableLegacyTips.get()).booleanValue()) continue;
                this.loadLegacyTip(id, stream);
            }
            catch (IOException e) {
                ImmersiveTips.LOGGER.error("Error occurred while loading resource tip {}", (Object)id.toString(), (Object)e);
            }
        }
        TipsResourceReloadListener.loadEnabledTips();
    }

    public static void loadEnabledTips() {
        ImmersiveTips.EnabledTips.clear();
        ImmersiveTip.Priority.VALUES.forEach(priority -> ImmersiveTips.EnabledTips.put((ImmersiveTip.Priority)((Object)priority), new ArrayList()));
        for (ImmersiveTip tip : ImmersiveTips.LocalTips) {
            if (ImmersiveTips.persistentData.seenTips.contains(tip.hashCode())) continue;
            ImmersiveTips.EnabledTips.get((Object)tip.priority).add(tip);
        }
        for (ImmersiveTip tip : ImmersiveTips.RemoteTips) {
            if (ImmersiveTips.persistentData.seenTips.contains(tip.hashCode())) continue;
            ImmersiveTips.EnabledTips.get((Object)tip.priority).add(tip);
        }
    }

    private void addDefaultTips(List<ImmersiveTip> tips) {
    }

    private void loadImmersiveTipList(ResourceLocation id, InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            JsonObject jsonElement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.loadPriorityList(id, ImmersiveTip.Priority.IMMEDIATE, jsonElement);
            this.loadPriorityList(id, ImmersiveTip.Priority.HIGH, jsonElement);
            this.loadPriorityList(id, ImmersiveTip.Priority.MEDIUM, jsonElement);
            this.loadPriorityList(id, ImmersiveTip.Priority.LOW, jsonElement);
        }
        catch (IOException e) {
            ImmersiveTips.LOGGER.error("Error occurred while reading stream for resource tip {}", (Object)id.toString(), (Object)e);
        }
    }

    private void loadPriorityList(ResourceLocation id, ImmersiveTip.Priority priority, JsonObject json) {
        JsonElement tipList = json.get(priority.m_7912_());
        if (tipList == null) {
            return;
        }
        if (!tipList.isJsonArray()) {
            ImmersiveTips.LOGGER.error("Error! JSON data for list '{}' in {} is not an array!", (Object)priority.m_7912_(), (Object)id);
            return;
        }
        JsonArray list = tipList.getAsJsonArray();
        list.forEach(element -> ImmersiveTip.CODEC.parse((DynamicOps)JsonOps.INSTANCE, element).resultOrPartial(errorMsg -> ImmersiveTips.LOGGER.error("Failed to decode ImmersiveTip: {}", errorMsg)).ifPresent(tip -> {
            tip.priority = priority;
            if (tip.priority == ImmersiveTip.Priority.IMMEDIATE) {
                tip.multiplier = Math.max(tip.multiplier, 1);
            }
            ImmersiveTips.LocalTips.add((ImmersiveTip)tip);
        }));
    }

    private void loadLegacyTip(ResourceLocation id, InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            JsonElement tipElement = jsonElement.getAsJsonObject().get("tip");
            if (tipElement == null) {
                ImmersiveTips.LOGGER.error("Failed to find 'tip' element in the JSON data for {}", (Object)id);
                return;
            }
            LEGACY_TIP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)tipElement).resultOrPartial(errorMsg -> ImmersiveTips.LOGGER.error("Failed to decode LegacyTip: {}", errorMsg)).ifPresent(legacyTip -> ImmersiveTips.LocalTips.add(new ImmersiveTip("Tip", legacyTip.translate)));
        }
        catch (IOException e) {
            ImmersiveTips.LOGGER.error("Error occurred while reading stream for resource tip {}", (Object)id.toString(), (Object)e);
        }
    }
}

