/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips.foundation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import toni.immersivetips.ImmersiveTips;

public class TipsPersistentData {
    public static final File FILE = new File("immersivetips.json");
    public static Date timeStarted = new Date();
    public static final Codec<TipsPersistentData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("playtime").forGetter(data -> data.playtime), (App)Codec.INT.listOf().optionalFieldOf("seenTips", new ArrayList()).forGetter(data -> data.seenTips)).apply((Applicative)instance, TipsPersistentData::new));
    public int playtime;
    public List<Integer> seenTips;

    public TipsPersistentData(Integer playtime, List<Integer> seenTips) {
        this.playtime = playtime;
        this.seenTips = seenTips;
    }

    public void save() {
        long millis = new Date().getTime() - timeStarted.getTime();
        this.playtime += (int)(millis / 1000L);
        timeStarted = new Date();
        try (FileWriter writer = new FileWriter(FILE);){
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, error -> {
                throw new RuntimeException("Failed to encode ImmersiveTips PersistentData: " + error);
            });
            writer.write(jsonElement.toString());
        }
        catch (Exception e) {
            ImmersiveTips.LOGGER.error("Failed to save ImmersiveTips PersistentData! ", (Throwable)e);
        }
    }

    public static TipsPersistentData load() {
        TipsPersistentData tipsPersistentData;
        if (!FILE.exists()) {
            return new TipsPersistentData(0, new ArrayList<Integer>());
        }
        FileReader reader = new FileReader(FILE);
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            tipsPersistentData = (TipsPersistentData)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, error -> {
                throw new RuntimeException("Failed to decode ImmersiveTips PersistentData: " + error);
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ImmersiveTips.LOGGER.error("Failed to load ImmersiveTips PersistentData! ", (Throwable)e);
                return new TipsPersistentData(0, new ArrayList<Integer>());
            }
        }
        reader.close();
        return tipsPersistentData;
    }
}

