/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.renderers.CaxtonRenderer;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.renderers.VanillaRenderer;
import toni.immersivetips.ImmersiveTips;
import toni.immersivetips.ImmersiveTipsClient;
import toni.immersivetips.foundation.ImmersiveTip;
import toni.immersivetips.foundation.config.AllConfigs;
import toni.lib.utils.PlatformUtils;

public class TipRenderer {
    private static final Queue<ImmersiveMessage> tooltipQueue = new LinkedList<ImmersiveMessage>();
    private static final ITooltipRenderer renderer = TipRenderer.initRenderer();
    private static final float NANOSECONDS_PER_TICK = 5.0E7f;
    private static long lastTime = System.nanoTime();
    private static ImmersiveMessage currentTooltip;

    public static void drawOnScreen(GuiGraphics graphics, Screen screen, float delta) {
        boolean isEnabled;
        boolean bl = isEnabled = ImmersiveTipsClient.EnabledScreens.contains(screen.getClass()) || ((List)AllConfigs.client().whitelistedScreens.get()).contains(screen.getClass().getName());
        if (!isEnabled || ((List)AllConfigs.client().blacklistedScreens.get()).contains(screen.getClass().getName())) {
            return;
        }
        if (ImmersiveTips.LocalTips.isEmpty() && ImmersiveTips.RemoteTips.isEmpty()) {
            return;
        }
        if (tooltipQueue.isEmpty()) {
            ImmersiveTip randomTip = ImmersiveTips.getNextTip();
            if (randomTip == null) {
                return;
            }
            randomTip.getMessage().animation.resetPlayhead(0.0f);
            if (randomTip.getMessage().subtext != null) {
                randomTip.getMessage().subtext.animation.resetPlayhead(0.0f);
            }
            tooltipQueue.add(randomTip.getMessage());
        }
        TipRenderer.render(graphics, delta);
    }

    static void render(GuiGraphics graphics, float delta) {
        long currentTime = System.nanoTime();
        float partialTicks = (float)(currentTime - lastTime) / 5.0E7f;
        lastTime = currentTime;
        if (currentTooltip == null) {
            if (tooltipQueue.isEmpty()) {
                return;
            }
            currentTooltip = tooltipQueue.remove();
        }
        TipRenderer.renderTooltip(graphics, partialTicks, currentTooltip, 0);
    }

    static void renderTooltip(GuiGraphics graphics, float deltaTicks, ImmersiveMessage tooltip, int depth) {
        tooltip.tick(deltaTicks);
        tooltip.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth == 0 && tooltip.animation.getCurrent() >= tooltip.animation.duration) {
            currentTooltip = null;
            return;
        }
        renderer.render(tooltip, graphics, deltaTicks);
        if (tooltip.subtext != null) {
            TipRenderer.renderTooltip(graphics, deltaTicks, tooltip.subtext, depth + 1);
        }
    }

    private static ITooltipRenderer initRenderer() {
        if (PlatformUtils.isModLoaded((String)"caxton")) {
            return new CaxtonRenderer();
        }
        return new VanillaRenderer();
    }

    static void showToPlayer(LocalPlayer player, ImmersiveMessage tooltip) {
        tooltipQueue.add(tooltip);
    }

    public static boolean hasTooltip() {
        return currentTooltip != null;
    }

    public static int queueCount() {
        return tooltipQueue.size();
    }

    @Generated
    public static ITooltipRenderer getRenderer() {
        return renderer;
    }
}

