/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.init;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamrazor.deepaether.DeepAether;
import teamrazor.deepaether.client.model.AerglowFishModel;
import teamrazor.deepaether.client.model.BabyZephyrModel;
import teamrazor.deepaether.client.model.ClassicEOTSSegmentModel;
import teamrazor.deepaether.client.model.EOTSModel;
import teamrazor.deepaether.client.model.EOTSSegmentModel;
import teamrazor.deepaether.client.model.GentleWindModel;
import teamrazor.deepaether.client.model.QuailModel;
import teamrazor.deepaether.client.model.ScarfModel;
import teamrazor.deepaether.client.model.VenomiteBubbleModel;
import teamrazor.deepaether.client.model.VenomiteModel;
import teamrazor.deepaether.client.model.WindflyModel;
import teamrazor.deepaether.client.renderer.AetherFishRenderer;
import teamrazor.deepaether.client.renderer.BabyZephyrRenderer;
import teamrazor.deepaether.client.renderer.DABoatRenderer;
import teamrazor.deepaether.client.renderer.DAModelLayers;
import teamrazor.deepaether.client.renderer.EOTSRenderer;
import teamrazor.deepaether.client.renderer.EOTSSegmentRenderer;
import teamrazor.deepaether.client.renderer.FireProjectileRenderer;
import teamrazor.deepaether.client.renderer.GentleWindRenderer;
import teamrazor.deepaether.client.renderer.QuailRenderer;
import teamrazor.deepaether.client.renderer.StormArrowRenderer;
import teamrazor.deepaether.client.renderer.VenomiteBubbleRenderer;
import teamrazor.deepaether.client.renderer.VenomiteRenderer;
import teamrazor.deepaether.client.renderer.WindCrystalRenderer;
import teamrazor.deepaether.client.renderer.WindflyRenderer;
import teamrazor.deepaether.entity.DABoatEntity;
import teamrazor.deepaether.init.DABlockEntityTypes;
import teamrazor.deepaether.init.DAEntities;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DAEntityRenderers {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)DAEntities.AERGLOW_FISH.get(), AetherFishRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.QUAIL.get(), QuailRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.VENOMITE.get(), VenomiteRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.WINDFLY.get(), WindflyRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DABlockEntityTypes.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DABlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.BOAT.get(), context -> new DABoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)DAEntities.CHEST_BOAT.get(), context -> new DABoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)DAEntities.QUAIL_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.FIRE_PROJECTILE.get(), FireProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.VENOMITE_BUBBLE.get(), VenomiteBubbleRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.EOTS_CONTROLLER.get(), EOTSRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.EOTS_SEGMENT.get(), EOTSSegmentRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.GENTLE_WIND.get(), GentleWindRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.WIND_CRYSTAL.get(), WindCrystalRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.STORM_ARROW.get(), StormArrowRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.BABY_ZEPHYR.get(), BabyZephyrRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DAModelLayers.AERGLOW_FISH, AerglowFishModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.EOTS_CONTROLLER, EOTSModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.EOTS_SEGMENT, EOTSSegmentModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.EOTS_SEGMENT_CLASSIC, ClassicEOTSSegmentModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.BABY_EOTS, GentleWindModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.VENOMITE_BUBBLE, VenomiteBubbleModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.BABY_ZEPHYR, BabyZephyrModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.WINDFLY, WindflyModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.VENOMITE, VenomiteModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.QUAIL, QuailModel::createBodyLayer);
        event.registerLayerDefinition(DAModelLayers.WIND_SHIELD, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)new CubeDeformation(1.1f), (boolean)false), (int)64, (int)64));
        event.registerLayerDefinition(DAModelLayers.WIND_SHIELD_SLIM, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)new CubeDeformation(1.15f), (boolean)true), (int)64, (int)64));
        event.registerLayerDefinition(DAModelLayers.WIND_SHIELD_ARM, () -> LayerDefinition.m_171565_((MeshDefinition)PlayerModel.m_170825_((CubeDeformation)new CubeDeformation(0.4f), (boolean)false), (int)64, (int)64));
        event.registerLayerDefinition(DAModelLayers.SCARF, ScarfModel::createBodyLayer);
        for (DABoatEntity.Type type : DABoatEntity.Type.values()) {
            event.registerLayerDefinition(new ModelLayerLocation(DeepAether.getResource(type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(DeepAether.getResource(type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
    }
}

