/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity;

import com.aetherteam.aether.entity.passive.Aerwhale;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import com.aetherteam.aether.item.AetherItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DASounds;

public class Windfly
extends AetherAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Float> DATA_X_ROT_O_ID = SynchedEntityData.m_135353_(Windfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_X_ROT_ID = SynchedEntityData.m_135353_(Windfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_Y_ROT_ID = SynchedEntityData.m_135353_(Windfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Windfly(EntityType<Windfly> type, Level world) {
        super(type, world);
        this.f_21365_ = new Aerwhale.BlankLookControl((Mob)this);
        this.f_21342_ = new WindflyMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new Aerwhale.SetTravelCourseGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.15f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DAEntities.WINDFLY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_X_ROT_O_ID, (Object)Float.valueOf(this.m_146909_()));
        this.m_20088_().m_135372_(DATA_X_ROT_ID, (Object)Float.valueOf(this.m_146909_()));
        this.m_20088_().m_135372_(DATA_Y_ROT_ID, (Object)Float.valueOf(this.m_146908_()));
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_146926_(this.getXRotData());
        this.m_146922_(this.getYRotData());
        this.m_5618_(this.getYRotData());
        this.m_5616_(this.getYRotData());
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public void m_8119_() {
        this.setXRotOData(this.getXRotData());
        if (this.f_19796_.m_188503_(90) == 0) {
            ItemEntity shard = new ItemEntity(this.m_9236_(), 0.0, 0.0, 0.0, new ItemStack((ItemLike)AetherItems.AMBROSIUM_SHARD.get()));
            shard.m_20219_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)shard);
        }
        if (this.f_19796_.m_188503_(7) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.3, this.m_20189_() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.f_19796_.m_188503_(7) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() - (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.3, this.m_20189_() - 0.5, 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    public void setXRotOData(float rot) {
        this.m_20088_().m_135381_(DATA_X_ROT_O_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getXRotData() {
        return ((Float)this.m_20088_().m_135370_(DATA_X_ROT_ID)).floatValue();
    }

    public void setXRotData(float rot) {
        this.m_20088_().m_135381_(DATA_X_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getYRotData() {
        return ((Float)this.m_20088_().m_135370_(DATA_Y_ROT_ID)).floatValue();
    }

    public void setYRotData(float rot) {
        this.m_20088_().m_135381_(DATA_Y_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(false);
        return flyingpathnavigation;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)DAEntities.WINDFLY.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_142535_(float v, float v1, DamageSource damageSource) {
        return false;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DASounds.WINDFLY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)DASounds.WINDFLY_HURT.get();
    }

    public static class WindflyMoveControl
    extends MoveControl {
        protected final Windfly mob;

        public WindflyMoveControl(Windfly pMob) {
            super((Mob)pMob);
            this.mob = pMob;
        }

        public void m_8126_() {
            if (!this.mob.m_20160_()) {
                double x = this.m_25000_() - this.mob.m_20185_();
                double y = this.m_25001_() - this.mob.m_20186_();
                double z = this.m_25002_() - this.mob.m_20189_();
                double distance = Math.sqrt(x * x + z * z);
                if (distance < 3.0 || this.isColliding(new Vec3(x, y, z).m_82541_())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
                float xRotTarget = (float)(Mth.m_14136_((double)y, (double)distance) * 57.2957763671875);
                float xRot = Mth.m_14177_((float)this.mob.m_146909_());
                xRot = Mth.m_14148_((float)xRot, (float)xRotTarget, (float)0.2f);
                this.mob.m_146926_(xRot);
                this.mob.setXRotData(this.mob.m_146909_());
                float yRotTarget = Mth.m_14177_((float)((float)Mth.m_14136_((double)z, (double)x) * 57.295776f));
                float yRot = Mth.m_14177_((float)(this.mob.m_146908_() + 90.0f));
                yRot = Mth.m_14148_((float)yRot, (float)yRotTarget, (float)0.5f);
                this.mob.m_146922_(yRot - 90.0f);
                this.mob.setYRotData(this.mob.m_146908_());
                this.mob.m_5618_(yRot);
                this.mob.m_5616_(yRot);
                x = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
                y = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
                z = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
                Vec3 motion = new Vec3(x, y, z);
                this.mob.m_20256_(motion);
                Entity entity = this.mob.m_21524_();
                if (entity != null && entity.m_9236_() == this.mob.m_9236_()) {
                    this.mob.m_21446_(entity.m_20183_(), 5);
                    float f = this.mob.m_20270_(entity);
                    if (f > 10.0f) {
                        this.mob.m_21455_(true, true);
                        this.mob.f_21345_.m_25355_(Goal.Flag.MOVE);
                    } else if (f > 6.0f) {
                        double d0 = (entity.m_20185_() - this.mob.m_20185_()) / (double)f;
                        double d1 = (entity.m_20186_() - this.mob.m_20186_()) / (double)f;
                        double d2 = (entity.m_20189_() - this.mob.m_20189_()) / (double)f;
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
                        this.mob.m_245125_();
                    }
                }
            }
        }

        private boolean isColliding(Vec3 pos) {
            AABB axisalignedbb = this.mob.m_20191_();
            for (int i = 1; i < 7; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(pos);
                if (this.mob.m_9236_().m_45756_((Entity)this.mob, axisalignedbb)) continue;
                return true;
            }
            return false;
        }
    }
}

