/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;
import teamrazor.deepaether.DeepAether;
import teamrazor.deepaether.entity.DABoatEntity;

public class DABoatRenderer<T extends DABoatEntity>
extends EntityRenderer<T> {
    private final Map<DABoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public DABoatRenderer(EntityRendererProvider.Context renderer, boolean hasChest) {
        super(renderer);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(DABoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)type.getTexture(hasChest), this.createBoatModel(renderer, (DABoatEntity.Type)((Object)type), hasChest))));
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context renderer, DABoatEntity.Type type, boolean hasChest) {
        ModelLayerLocation modelLayerLocation = hasChest ? new ModelLayerLocation(DeepAether.getResource(type.getChestModelLocation()), "main") : new ModelLayerLocation(DeepAether.getResource(type.getModelLocation()), "main");
        ModelPart modelPart = renderer.m_174023_(modelLayerLocation);
        return hasChest ? new ChestBoatModel(modelPart) : new BoatModel(modelPart);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.375f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float g = entity.m_38384_() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * g / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)entity.m_38352_(partialTicks), (float)0.0f)) {
            matrixStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.boatResources.get((Object)((DABoatEntity)((Object)entity)).getWoodType());
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ListModel listModel = (ListModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listModel.m_6973_(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(listModel.m_103119_(resourceLocation));
        listModel.m_7695_(matrixStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexConsumer2 = buffer.m_6299_(RenderType.m_110478_());
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.m_102282_().m_104301_(matrixStack, vertexConsumer2, packedLight, OverlayTexture.f_118083_);
            }
        }
        matrixStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(DABoatEntity boat) {
        return (ResourceLocation)this.boatResources.get((Object)boat.getWoodType()).getFirst();
    }
}

