/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.habitats;

import com.github.kay9.dragonmounts.habitats.Habitat;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record PickyHabitat(List<Habitat> habitats) implements Habitat
{
    public static final Codec<PickyHabitat> CODEC = Habitat.CODEC.listOf().fieldOf("required_habitats").xmap(PickyHabitat::new, PickyHabitat::habitats).codec();

    @Override
    public int getHabitatPoints(Level level, BlockPos pos) {
        int points = 0;
        for (Habitat habitat : this.habitats) {
            int i = habitat.getHabitatPoints(level, pos);
            if (i == 0) {
                return 0;
            }
            points += i;
        }
        return points;
    }

    @Override
    public ResourceLocation type() {
        return Habitat.PICKY;
    }
}

