/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.client.DragonAnimator;
import com.github.kay9.dragonmounts.client.KeyMappings;
import com.github.kay9.dragonmounts.client.MountCameraManager;
import com.github.kay9.dragonmounts.client.MountControlsMessenger;
import com.github.kay9.dragonmounts.data.CrossBreedingManager;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.ai.DragonBodyController;
import com.github.kay9.dragonmounts.dragon.ai.DragonBreedGoal;
import com.github.kay9.dragonmounts.dragon.ai.DragonFollowOwnerGoal;
import com.github.kay9.dragonmounts.dragon.ai.DragonMoveController;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlock;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TameableDragon
extends TamableAnimal
implements Saddleable,
FlyingAnimal,
PlayerRideable {
    public static final double BASE_SPEED_GROUND = 0.3;
    public static final double BASE_SPEED_FLYING = 0.32;
    public static final double BASE_DAMAGE = 8.0;
    public static final double BASE_HEALTH = 60.0;
    public static final double BASE_FOLLOW_RANGE = 16.0;
    public static final int BASE_KB_RESISTANCE = 1;
    public static final float BASE_WIDTH = 2.75f;
    public static final float BASE_HEIGHT = 2.75f;
    public static final int BASE_REPRO_LIMIT = 2;
    public static final int BASE_GROWTH_TIME = 72000;
    public static final float BASE_SIZE_MODIFIER = 1.0f;
    private static final EntityDataAccessor<String> DATA_BREED = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String NBT_BREED = "Breed";
    private static final String NBT_SADDLED = "Saddle";
    private static final String NBT_REPRO_COUNT = "ReproCount";
    public static final int AGE_UPDATE_INTERVAL = 100;
    public static final UUID SCALE_MODIFIER_UUID = UUID.fromString("856d4ba4-9ffe-4a52-8606-890bb9be538b");
    public static final int GROUND_CLEARENCE_THRESHOLD = 3;
    private final DragonAnimator animator;
    private final List<Ability> abilities = new ArrayList<Ability>();
    private DragonBreed breed;
    private int reproCount;
    private float ageProgress = 1.0f;
    private boolean flying;
    private boolean nearGround;
    private final GroundPathNavigation groundNavigation;
    private final FlyingPathNavigation flyingNavigation;

    public TameableDragon(EntityType<? extends TameableDragon> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.f_21342_ = new DragonMoveController(this);
        this.animator = level.f_46443_ ? new DragonAnimator(this) : null;
        this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingNavigation.m_7008_(true);
        this.groundNavigation.m_7008_(true);
        this.f_21344_ = this.groundNavigation;
    }

    @NotNull
    public BodyRotationControl m_7560_() {
        return new DragonBodyController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22280_, 0.32);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new DragonFollowOwnerGoal(this, 1.0, 10.0f, 3.5f, 32.0f));
        this.f_21345_.m_25352_(5, (Goal)new DragonBreedGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.85f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 16.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> !(e instanceof TameableDragon)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BREED, (Object)"");
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_BREED.equals(data)) {
            this.setBreed(BreedRegistry.get((String)this.f_19804_.m_135370_(DATA_BREED), this.m_9236_().m_9598_()));
            this.updateAgeProperties();
        } else if (f_21798_.equals(data)) {
            this.m_6210_();
        } else if (DATA_AGE.equals(data)) {
            this.updateAgeProperties();
        } else {
            super.m_7350_(data);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(NBT_SADDLED, this.m_6254_());
        compound.m_128405_(NBT_REPRO_COUNT, this.reproCount);
        if (this.getBreed() != null) {
            compound.m_128359_(NBT_BREED, this.getBreed().id(this.m_9236_().m_9598_()).toString());
            for (Ability ability : this.getAbilities()) {
                ability.write(this, compound);
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        DragonBreed breed = BreedRegistry.get(compound.m_128461_(NBT_BREED), this.m_9236_().m_9598_());
        if (breed != null) {
            this.setBreed(breed);
        }
        super.m_7378_(compound);
        this.setSaddled(compound.m_128471_(NBT_SADDLED));
        this.reproCount = compound.m_128451_(NBT_REPRO_COUNT);
        for (Ability ability : this.getAbilities()) {
            ability.read(this, compound);
        }
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.m_146764_());
    }

    public void setBreed(DragonBreed dragonBreed) {
        if (this.breed != dragonBreed) {
            if (this.breed != null) {
                this.breed.close(this);
            }
            this.breed = dragonBreed;
            this.breed.initialize(this);
            this.m_20088_().m_135381_(DATA_BREED, (Object)this.breed.id(this.m_9236_().m_9598_()).toString());
        }
    }

    @Nullable
    public DragonBreed getBreed() {
        return this.breed;
    }

    public Optional<DragonBreed> getBreedOptionally() {
        return Optional.ofNullable(this.breed);
    }

    public List<Ability> getAbilities() {
        return this.abilities;
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.isHatchling() && this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.setSaddled(true);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, this.m_5720_(), 1.0f, 1.0f);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddled);
    }

    public void addReproCount() {
        ++this.reproCount;
    }

    public boolean canFly() {
        return !this.isHatchling();
    }

    public boolean shouldFly() {
        if (this.m_29443_()) {
            return !this.m_20096_();
        }
        return this.canFly() && !this.m_20069_() && !this.isNearGround();
    }

    public boolean m_29443_() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public boolean isNearGround() {
        return this.nearGround;
    }

    public void setNavigation(boolean flying) {
        this.f_21344_ = flying ? this.flyingNavigation : this.groundNavigation;
    }

    public void m_8119_() {
        if (this.isServer() && this.breed == null) {
            this.setBreed(BreedRegistry.getRandom(this.m_9236_().m_9598_(), this.m_217043_()));
        }
        super.m_8119_();
        if (this.isServer()) {
            if (!this.isAdult() && this.f_19797_ % 100 == 0) {
                this.f_19804_.m_135381_(DATA_AGE, (Object)this.f_146733_);
            }
        } else {
            this.animator.tick();
            int age = this.m_146764_();
            if (age < 0) {
                this.m_146762_(++age);
            } else if (age > 0) {
                this.m_146762_(--age);
            }
        }
        this.nearGround = this.m_20096_() || !this.m_9236_().m_45756_((Entity)this, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_() - (double)(3.0f * this.m_6134_()), this.m_20189_()));
        boolean flying = this.shouldFly();
        if (flying != this.m_29443_()) {
            this.setFlying(flying);
            if (this.isServer()) {
                this.setNavigation(flying);
            }
        }
        this.updateAgeProgress();
        for (Ability ability : this.getAbilities()) {
            ability.tick(this);
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_29443_()) {
            if (this.m_6109_()) {
                this.m_19920_(this.m_6113_(), vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_20184_().m_82556_() < 0.1) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, Math.sin((float)this.f_19797_ / 4.0f) * 0.03, 0.0));
                }
                this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            }
            this.m_267651_(true);
        } else {
            super.m_7023_(vec3);
        }
    }

    protected Vec3 m_274312_(Player driver, Vec3 move) {
        double moveSideways = move.f_82479_;
        double moveY = move.f_82480_;
        double moveForward = Math.min(Math.abs(driver.f_20902_) + Math.abs(driver.f_20900_), 1.0f);
        if (this.m_29443_() && this.hasLocalDriver()) {
            double d = moveForward = moveForward > 0.0 ? moveForward : 0.0;
            if (driver.f_20899_) {
                moveY = 1.0;
            } else if (KeyMappings.FLIGHT_DESCENT_KEY.m_90857_()) {
                moveY = -1.0;
            } else if (moveForward > 0.0 && DMLConfig.cameraDrivenFlight()) {
                moveY = -driver.m_146909_() / 90.0f;
            }
        }
        float speed = this.m_245547_(driver);
        return new Vec3(moveSideways * (double)speed, moveY * (double)speed, moveForward * (double)speed);
    }

    protected void m_274498_(Player driver, Vec3 move) {
        float yaw = driver.f_20885_;
        if (move.f_82481_ > 0.0) {
            yaw += (float)Mth.m_14136_((double)driver.f_20902_, (double)driver.f_20900_) * 57.295776f - 90.0f;
        }
        this.f_20885_ = yaw;
        this.m_146926_(driver.m_146909_() * 0.68f);
        this.m_146922_(Mth.m_14094_((float)this.f_20885_, (float)this.m_146908_(), (float)4.0f));
        if (this.m_6109_() && !this.m_29443_() && this.canFly() && driver.f_20899_) {
            this.liftOff();
        }
    }

    protected float m_245547_(Player driver) {
        return (float)this.m_21133_(this.m_29443_() ? Attributes.f_22280_ : Attributes.f_22279_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult stackResult = stack.m_41647_(player, (LivingEntity)this, hand);
        if (stackResult.m_19077_()) {
            return stackResult;
        }
        if (!this.m_21824_()) {
            if (this.isServer() && this.getBreed().tamingItems().m_203333_((Holder)stack.m_41720_().m_204114_())) {
                stack.m_41774_(1);
                this.tamedFor(player, this.m_217043_().m_188503_(5) == 0);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.getHealthFraction() < 1.0f && this.isFoodItem(stack)) {
            this.m_5634_(stack.m_41720_().getFoodProperties(stack, (LivingEntity)this).m_38744_());
            this.m_5496_(this.m_7866_(stack), 0.7f, 1.0f);
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTamedFor(player) && this.m_6741_() && !this.m_6254_() && stack.m_41720_() instanceof SaddleItem) {
            stack.m_41774_(1);
            this.m_5853_(this.m_5720_());
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTamedFor(player) && this.m_6254_() && stack.m_204117_(Tags.Items.SHEARS)) {
            this.m_19998_((ItemLike)Items.f_42450_);
            player.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            this.setSaddled(false);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTamedFor(player) && (player.m_36341_() || stack.m_150930_(Items.f_42500_))) {
            if (this.isServer()) {
                this.f_21344_.m_26573_();
                this.m_21839_(!this.m_21827_());
                if (this.m_21827_()) {
                    this.m_6710_(null);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTamedFor(player) && this.m_6254_() && !this.isHatchling() && !this.m_6898_(stack)) {
            if (this.isServer()) {
                player.m_20329_((Entity)this);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
            this.m_21839_(false);
            this.m_21837_(false);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void liftOff() {
        if (this.canFly()) {
            this.m_6135_();
        }
    }

    protected float m_6118_() {
        return super.m_6118_() * (float)(this.canFly() ? 3 : 1);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return !this.canFly() && super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    protected void m_6153_() {
        this.m_20153_();
        this.m_20256_(Vec3.f_82478_);
        this.m_146922_(this.f_19859_);
        this.m_5616_(this.f_20886_);
        if (this.f_20919_ >= this.getMaxDeathTime()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        ++this.f_20919_;
    }

    protected SoundEvent m_7515_() {
        return this.getBreedOptionally().flatMap(DragonBreed::ambientSound).map(Holder::get).orElse((SoundEvent)DMLRegistry.DRAGON_AMBIENT_SOUND.get());
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11895_;
    }

    public SoundEvent getStepSound() {
        return (SoundEvent)DMLRegistry.DRAGON_STEP_SOUND.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DMLRegistry.DRAGON_DEATH_SOUND.get();
    }

    public SoundEvent m_7866_(ItemStack itemStackIn) {
        return SoundEvents.f_11912_;
    }

    public SoundEvent getAttackSound() {
        return SoundEvents.f_11912_;
    }

    public SoundEvent getWingsSound() {
        return SoundEvents.f_11893_;
    }

    protected void m_7355_(BlockPos entityPos, BlockState state) {
        if (this.m_20069_()) {
            return;
        }
        if (this.isHatchling()) {
            super.m_7355_(entityPos, state);
            return;
        }
        SoundType soundType = state.m_60827_();
        if (this.m_9236_().m_8055_(entityPos.m_7494_()).m_60734_() == Blocks.f_50125_) {
            soundType = Blocks.f_50125_.getSoundType(state, (LevelReader)this.m_9236_(), entityPos, (Entity)this);
        }
        this.m_5496_(this.getStepSound(), soundType.m_56773_(), soundType.m_56774_() * this.m_6100_());
    }

    public void m_8032_() {
        if (this.getBreed() != null) {
            super.m_8032_();
        }
    }

    public int m_8100_() {
        return 240;
    }

    protected float m_6121_() {
        return this.m_6134_();
    }

    public float m_6100_() {
        return 2.0f - this.m_6134_();
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.getBreed() == null) {
            return ItemStack.f_41583_;
        }
        return DragonSpawnEgg.create(this.getBreed(), this.m_9236_().m_9598_());
    }

    protected Component m_5677_() {
        if (this.getBreed() != null) {
            return Component.m_237115_((String)DragonBreed.getTranslationKey(this.getBreed().id(this.m_9236_().m_9598_()).toString()));
        }
        return super.m_5677_();
    }

    public boolean isFoodItem(ItemStack stack) {
        FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)this);
        return food != null && food.m_38746_();
    }

    public boolean m_6898_(ItemStack stack) {
        return this.getBreed().breedingItems().m_203333_((Holder)stack.m_41720_().m_204114_());
    }

    public void tamedFor(Player player, boolean successful) {
        if (successful) {
            this.m_7105_(true);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21816_(player.m_20148_());
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    public boolean isTamedFor(Player player) {
        return this.m_21824_() && this.m_21830_((LivingEntity)player);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 1.2f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() - 0.175;
    }

    public float m_6134_() {
        float mod = this.getBreed() == null ? 1.0f : this.getBreed().sizeModifier();
        return (0.33f + 0.67f * this.getAgeProgress()) * mod;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6147_() {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    protected ResourceLocation m_7582_() {
        if (this.getBreed() == null) {
            return BuiltInLootTables.f_78712_;
        }
        return this.getBreed().deathLoot();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean attacked = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        if (attacked) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return attacked;
    }

    public void onWingsDown(float speed) {
        if (!this.m_20069_()) {
            float pitch = 1.0f - speed;
            float volume = 0.3f + (1.0f - speed) * 0.2f;
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getWingsSound(), SoundSource.VOICE, volume *= this.m_6121_(), pitch *= this.m_6100_(), true);
        }
    }

    public void m_6674_(InteractionHand hand) {
        this.m_5496_(this.getAttackSound(), 1.0f, 0.7f);
        super.m_6674_(hand);
    }

    public boolean m_6469_(DamageSource src, float par2) {
        if (this.m_6673_(src)) {
            return false;
        }
        this.m_21839_(false);
        return super.m_6469_(src, par2);
    }

    public boolean m_7848_(Animal mate) {
        if (mate == this) {
            return false;
        }
        if (!(mate instanceof TameableDragon)) {
            return false;
        }
        TameableDragon dragonMate = (TameableDragon)mate;
        if (!this.canReproduce()) {
            return false;
        }
        if (!dragonMate.canReproduce()) {
            return false;
        }
        return this.m_27593_() && mate.m_27593_();
    }

    public boolean canReproduce() {
        if (!this.m_21824_() || this.getBreed() == null) {
            return false;
        }
        int limit = this.getBreed().getReproductionLimit();
        return this.reproCount < limit || limit == -1;
    }

    public void m_27563_(ServerLevel level, Animal animal) {
        if (!(animal instanceof TameableDragon)) {
            DragonMountsLegacy.LOG.warn("Tried to mate with non-dragon? Hello? {}", (Object)animal);
            return;
        }
        TameableDragon mate = (TameableDragon)animal;
        BlockState state = (BlockState)((Block)DMLRegistry.EGG_BLOCK.get()).m_49966_().m_61124_((Property)HatchableEggBlock.HATCHING, (Comparable)Boolean.valueOf(true));
        DragonBreed offSpringBreed = CrossBreedingManager.INSTANCE.getCrossBreed(this.getBreed(), mate.getBreed(), level.m_9598_());
        if (offSpringBreed == null) {
            offSpringBreed = this.m_217043_().m_188499_() ? this.getBreed() : mate.getBreed();
        }
        HatchableEggBlockEntity egg = HatchableEggBlock.place(level, this.m_20183_(), state, offSpringBreed);
        if (this.m_8077_() && animal.m_8077_()) {
            String babyName;
            String p1Name = this.m_7770_().getString();
            String p2Name = animal.m_7770_().getString();
            if (p1Name.contains(" ") || p2Name.contains(" ")) {
                String[] p1Names = p1Name.split(" ");
                String[] p2Names = p2Name.split(" ");
                p1Name = StringUtils.capitalize((String)p1Names[this.m_217043_().m_188503_(p1Names.length)]);
                p2Name = StringUtils.capitalize((String)p2Names[this.m_217043_().m_188503_(p2Names.length)]);
                babyName = this.m_217043_().m_188499_() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
            } else {
                p1Name = this.m_217043_().m_188499_() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                p2Name = this.m_217043_().m_188499_() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                p2Name = StringUtils.capitalize((String)p2Name);
                babyName = this.m_217043_().m_188499_() ? p1Name + p2Name : p2Name + p1Name;
            }
            egg.setCustomName((Component)Component.m_237113_((String)babyName));
        }
        this.addReproCount();
        mate.addReproCount();
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        TameableDragon offspring = (TameableDragon)((EntityType)DMLRegistry.DRAGON.get()).m_20615_((Level)level);
        if (this.getBreed() != null) {
            offspring.setBreed(this.getBreed());
        }
        return offspring;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TamableAnimal tameable;
        return !(target instanceof TamableAnimal) || !Objects.equals((tameable = (TamableAnimal)target).m_269323_(), owner);
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isHatchling() && !this.m_217005_() && super.m_6779_(target);
    }

    public LivingEntity m_6688_() {
        LivingEntity driver;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity && this.m_21830_(driver = (LivingEntity)entity) ? driver : null;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (passenger instanceof Player) {
            passenger.m_146922_(this.m_146908_());
            passenger.m_146926_(this.m_146909_());
        }
        if (this.hasLocalDriver()) {
            MountControlsMessenger.sendControlsMessage();
            MountCameraManager.onDragonMount();
        }
    }

    protected void m_20351_(Entity passenger) {
        if (this.hasLocalDriver()) {
            MountCameraManager.onDragonDismount();
        }
        super.m_20351_(passenger);
    }

    protected void m_19956_(Entity ridden, Entity.MoveFunction pCallback) {
        if (this.m_20363_(ridden)) {
            Vec3 rePos = new Vec3(0.0, this.m_6048_() + ridden.m_6049_(), (double)this.m_6134_()).m_82524_((float)Math.toRadians(-this.f_20883_)).m_82549_(this.m_20182_());
            pCallback.m_20372_(ridden, rePos.f_82479_, rePos.f_82480_, rePos.f_82481_);
            if (this.m_146895_() instanceof LivingEntity) {
                ridden.f_19860_ = ridden.m_146909_();
                ridden.f_19859_ = ridden.m_146908_();
                ridden.m_5618_(this.f_20883_);
            }
        }
    }

    public boolean m_6673_(DamageSource src) {
        Entity srcEnt = src.m_7639_();
        if (srcEnt != null && (srcEnt == this || this.m_20363_(srcEnt))) {
            return true;
        }
        if (this.getBreed() != null) {
            return this.getBreed().immunities().m_203333_(src.m_269150_());
        }
        return super.m_6673_(src);
    }

    public float getHealthFraction() {
        return this.m_21223_() / this.m_21233_();
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public void m_6210_() {
        double posXTmp = this.m_20185_();
        double posYTmp = this.m_20186_();
        double posZTmp = this.m_20189_();
        boolean onGroundTmp = this.m_20096_();
        super.m_6210_();
        this.m_6034_(posXTmp, posYTmp, posZTmp);
        this.m_6853_(onGroundTmp);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        float height = this.m_21825_() ? 2.15f : 2.75f;
        float scale = this.m_6134_();
        return new EntityDimensions(2.75f * scale, height * scale, false);
    }

    public int m_146764_() {
        return this.f_146733_;
    }

    public void updateAgeProgress() {
        float growth = -72000.0f;
        if (this.getBreed() != null) {
            growth = -this.getBreed().growthTime();
        }
        float min = Math.min(this.m_146764_(), 0);
        this.ageProgress = 1.0f - min / growth;
    }

    public float getAgeProgress() {
        return this.ageProgress;
    }

    private void updateAgeProperties() {
        this.m_146762_((Integer)this.f_19804_.m_135370_(DATA_AGE));
        this.updateAgeProgress();
        this.m_6210_();
        this.m_274367_(Math.max(2.0f * this.getAgeProgress(), 1.0f));
        if (this.isServer()) {
            float healthFrac = this.getHealthFraction();
            double modValue = -(1.0 - Math.max((double)this.getAgeProgress(), 0.1));
            AttributeModifier mod = new AttributeModifier(SCALE_MODIFIER_UUID, "Dragon size modifier", modValue, AttributeModifier.Operation.MULTIPLY_BASE);
            for (Attribute attribute : new Attribute[]{Attributes.f_22276_, Attributes.f_22281_}) {
                AttributeInstance instance = this.m_21051_(attribute);
                instance.m_22130_(mod);
                instance.m_22118_(mod);
            }
            this.m_21153_(healthFrac * this.m_21233_());
        }
    }

    public boolean isHatchling() {
        return this.getAgeProgress() < 0.5f;
    }

    public boolean isJuvenile() {
        return this.getAgeProgress() >= 0.5f && this.getAgeProgress() < 1.0f;
    }

    public boolean isAdult() {
        return this.getAgeProgress() >= 1.0f;
    }

    public boolean m_6162_() {
        return !this.isAdult();
    }

    public void m_6863_(boolean baby) {
        int growth = -72000;
        if (this.getBreed() != null) {
            growth = -this.getBreed().growthTime();
        }
        this.m_146762_(baby ? growth : 0);
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.f_146733_);
    }

    public void m_146740_(int p_146741_, boolean p_146742_) {
        super.m_146740_(p_146741_, p_146742_);
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.m_146764_());
    }

    public boolean isServer() {
        return !this.m_9236_().f_46443_;
    }

    public DragonAnimator getAnimator() {
        return this.animator;
    }

    public boolean m_6040_() {
        if (this.getBreed() == null) {
            return super.m_6040_();
        }
        return this.getBreed().immunities().m_203333_(this.m_269291_().m_269063_().m_269150_());
    }

    public boolean m_5825_() {
        if (super.m_5825_()) {
            return true;
        }
        if (this.getBreed() == null) {
            return false;
        }
        return this.getBreed().immunities().m_203333_(this.m_269291_().m_269549_().m_269150_());
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        for (Ability ability : this.getAbilities()) {
            ability.onMove(this);
        }
    }

    public boolean m_5830_() {
        if (this.f_19794_) {
            return false;
        }
        AABB collider = this.m_20191_().m_82406_((double)(this.m_20205_() * 0.2f));
        return BlockPos.m_121921_((AABB)collider).anyMatch(pos -> {
            BlockState state = this.m_9236_().m_8055_(pos);
            return !state.m_60795_() && state.m_60828_((BlockGetter)this.m_9236_(), pos) && Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.m_9236_(), pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)collider), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public Vec3 m_7371_(float p_20309_) {
        return new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean hasLocalDriver() {
        Player p;
        LivingEntity livingEntity = this.m_6688_();
        return livingEntity instanceof Player && (p = (Player)livingEntity).m_7578_();
    }
}

