/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.data.loot.DragonEggLootMod;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class DMLConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final ForgeConfigSpec.BooleanValue ALLOW_EGG_OVERRIDE;
    private static final ForgeConfigSpec.BooleanValue REPLENISH_EGGS;
    private static final ForgeConfigSpec.BooleanValue USE_LOOT_TABLES;
    private static final ForgeConfigSpec.BooleanValue UPDATE_HABITATS;
    private static final Map<String, ForgeConfigSpec.DoubleValue> EGG_CHANCES;
    private static final Map<String, ForgeConfigSpec.IntValue> REPRO_LIMITS;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec.BooleanValue CAMERA_DRIVEN_FLIGHT;
    public static final ForgeConfigSpec.BooleanValue THIRD_PERSON_ON_MOUNT;
    private static final ForgeConfigSpec.DoubleValue[][] CAMERA_OFFSETS;

    public static boolean allowEggOverride() {
        return (Boolean)ALLOW_EGG_OVERRIDE.get();
    }

    public static boolean replenishEggs() {
        return (Boolean)REPLENISH_EGGS.get();
    }

    public static boolean useLootTables() {
        return (Boolean)USE_LOOT_TABLES.get();
    }

    public static boolean updateHabitats() {
        return (Boolean)UPDATE_HABITATS.get();
    }

    public static float getEggChanceFor(String configTarget) {
        ForgeConfigSpec.DoubleValue chance = EGG_CHANCES.get(configTarget);
        if (chance == null) {
            return -1.0f;
        }
        return ((Double)chance.get()).floatValue();
    }

    public static int getReproLimitFor(String configTarget) {
        ForgeConfigSpec.IntValue limit = REPRO_LIMITS.get(configTarget.replace("config:", ""));
        if (limit == null) {
            return -1;
        }
        return (Integer)limit.get();
    }

    public static boolean cameraDrivenFlight() {
        return (Boolean)CAMERA_DRIVEN_FLIGHT.get();
    }

    public static boolean thirdPersonOnMount() {
        return (Boolean)THIRD_PERSON_ON_MOUNT.get();
    }

    public static ForgeConfigSpec.DoubleValue[] getCameraPerspectiveOffset(boolean back) {
        return CAMERA_OFFSETS[back ? 0 : 1];
    }

    private static ImmutableMap<String, ForgeConfigSpec.DoubleValue> defineChanceEntries(ForgeConfigSpec.Builder configurator) {
        ImmutableMap.Builder chances = ImmutableMap.builder();
        for (DragonEggLootMod.Target target : DragonEggLootMod.BUILT_IN_CHANCES) {
            String path = DMLConfig.formatEggTargetAsPath(target.forBreed().m_135782_(), target.target());
            ForgeConfigSpec.DoubleValue entry = configurator.comment(new String[]{String.format("The chance that a %s egg appears in %s.", target.forBreed().m_135782_().m_135815_(), target.target().m_135815_()), "0 = Never Appears, 1 = Guaranteed"}).defineInRange(path, target.chance(), 0.0, 1.0);
            chances.put((Object)path, (Object)entry);
        }
        return chances.build();
    }

    private static ImmutableMap<String, ForgeConfigSpec.IntValue> defineReproLimEntries(ForgeConfigSpec.Builder configurator) {
        ImmutableMap.Builder lims = ImmutableMap.builder();
        for (ResourceKey type : new ResourceKey[]{DragonBreed.BuiltIn.AETHER, DragonBreed.BuiltIn.END, DragonBreed.BuiltIn.FIRE, DragonBreed.BuiltIn.FOREST, DragonBreed.BuiltIn.GHOST, DragonBreed.BuiltIn.ICE, DragonBreed.BuiltIn.NETHER, DragonBreed.BuiltIn.WATER}) {
            String path = type.m_135782_().m_135815_();
            lims.put((Object)path, (Object)configurator.comment("-1 = No Limit, 0 = Cannot breed, 2 = Can breed only two times").defineInRange(path, 2, -1, Integer.MAX_VALUE));
        }
        return lims.build();
    }

    public static String formatEggTargetAsPath(ResourceLocation forBreed, ResourceLocation forTarget) {
        return String.format("%s_in_%s_chance", forBreed.m_135815_(), forTarget.m_135815_().substring(forTarget.m_135815_().lastIndexOf(47) + 1));
    }

    private static void defineCameraOffsetEntries(ForgeConfigSpec.Builder configurator) {
        String perspectiveName = "back";
        for (ForgeConfigSpec.DoubleValue[] perspective : CAMERA_OFFSETS) {
            configurator.push("third_person_" + perspectiveName);
            perspectiveName = "front";
            perspective[0] = configurator.defineInRange("distance", 6.0, -3.0, 1000.0);
            perspective[1] = configurator.defineInRange("vertical", 4.0, -3.0, 1000.0);
            perspective[2] = configurator.defineInRange("horizontal", 0.0, -1000.0, 1000.0);
            configurator.pop();
        }
    }

    static {
        ForgeConfigSpec.Builder configurator = new ForgeConfigSpec.Builder().push("config");
        ALLOW_EGG_OVERRIDE = configurator.comment(new String[]{"Allow the vanilla ender egg to be interacted with? (Hatchable)", "Useful to help with mod compatibility"}).define("allow_egg_override", true);
        REPLENISH_EGGS = configurator.comment(new String[]{"Should Ender Dragon Eggs replenish on the exit portal after a respawned dragon is defeated?", "Useful for multiplayer scenarios.", "NOTE: This may break with mods that add content in the end. (A big example is YUNG's better end islands)", "You should see if those mods have ways to replenish dragon eggs themselves."}).define("replenish_eggs", true);
        USE_LOOT_TABLES = configurator.comment(new String[]{"Should dragon eggs generate in treasure chest loot tables?", "Useful for multiplayer scenarios and offering alternative ways to obtain eggs.", "Egg chance values can be modified below. If you'd like to change the loot tables the eggs appear", "in, consider using a datapack, since the static nature of configs complicates things."}).define("use_loot_tables", false);
        UPDATE_HABITATS = configurator.comment("Should Dragon Eggs adapt to their environments and change breeds?").define("update_habitats", true);
        configurator.pop();
        configurator.comment(new String[]{"!!! THESE VALUES DO NOT TAKE EFFECT UNTIL `use_loot_tables` ABOVE IS SET TO `true` !!!", "These entries define the chance values of which a dragon egg can appear in its respective loot table.", "Due to the static nature of configs in general, DML cannot modify the chances of custom breed eggs", "outside the built-in defaults, so those should be configured to use minecraft's built in random chance conditions.", "(It is however, possible to point custom egg chances to the built-in values via the loot condition, therefore using a config chance)"}).push("egg_loot_chances");
        EGG_CHANCES = DMLConfig.defineChanceEntries(configurator);
        configurator.pop();
        configurator.comment(new String[]{"These entries define the reproduction (breed) limits of each dragon breed.", "Due to the static nature of configs in general, DML cannot modify the reproduction limits of custom breeds", "outside the mod's built in breeds. Those should be configured in datapacks to use a direct number rather", "than point to an entry here (unless that's the goal.)"}).push("reproduction_limits");
        REPRO_LIMITS = DMLConfig.defineReproLimEntries(configurator);
        configurator.pop();
        COMMON_SPEC = configurator.build();
        CAMERA_OFFSETS = new ForgeConfigSpec.DoubleValue[2][3];
        configurator = new ForgeConfigSpec.Builder().push("client");
        CAMERA_DRIVEN_FLIGHT = configurator.comment(new String[]{"Is dragon flight vertical movement driven by the pitch of the game camera?", "This option can be toggled in-game via keybinding for quick switching.", "If you choose to disable this, vertical movement can still be achieved via dedicated keybindings."}).define("camera_driven_flight", true);
        THIRD_PERSON_ON_MOUNT = configurator.comment("When mounting and dismounting a dragon, should the camera automatically switch third-person perspectives?").define("third_person_on_mount", true);
        configurator.pop();
        configurator.comment("The values that define the offset of the camera position when riding a dragon in the third person camera.").push("camera_offsets");
        DMLConfig.defineCameraOffsetEntries(configurator);
        configurator.pop();
        CLIENT_SPEC = configurator.build();
    }
}

