/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.base.Suppliers;
import java.util.Calendar;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.TetraCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class MiscUtils {
    public static final Festivity FESTIVITY = Festivity.get();
    private static final Supplier<ShulkerBoxBlockEntity> SHULKER_TILE = Suppliers.memoize(() -> new ShulkerBoxBlockEntity(BlockPos.f_121853_, Blocks.f_50456_.m_49966_()));

    public static boolean showsHints(BlockGetter worldIn, TooltipFlag flagIn) {
        if (worldIn instanceof Level) {
            Level l = (Level)worldIn;
            if (l.f_46443_) {
                return ClientConfigs.General.TOOLTIP_HINTS.get();
            }
        }
        return false;
    }

    @Nullable
    public static Entity cloneEntity(Entity entity, ServerLevel level) {
        CompoundTag c = new CompoundTag();
        entity.m_20223_(c);
        Optional opt = EntityType.m_20642_((CompoundTag)c, (Level)level);
        return opt.orElse(null);
    }

    public static boolean isSword(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_SWORDS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraSword(i)) {
            return true;
        }
        return i instanceof SwordItem;
    }

    public static boolean isTool(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_TOOLS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraTool(i)) {
            return true;
        }
        return i instanceof DiggerItem || i instanceof TridentItem;
    }

    public static AABB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.m_5484_(facing, offset);
        switch (facing) {
            case NORTH: {
                endPos = endPos.m_7918_(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.m_7918_(1, 1, 1);
                pos = pos.m_7918_(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.m_7918_(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.m_7918_(1, 0, 1);
            }
        }
        return new AABB(pos, endPos);
    }

    public static boolean isAllowedInShulker(ItemStack stack, Level level) {
        ShulkerBoxBlockEntity te = SHULKER_TILE.get();
        te.m_142339_(level);
        boolean first = te.m_7155_(0, stack, null);
        te.m_142339_(null);
        return first && stack.m_41720_().m_142095_();
    }

    public static boolean withinDistanceDown(BlockPos pos, Vec3 vector, double distW, double distDown) {
        double dx = vector.m_7096_() - ((double)pos.m_123341_() + 0.5);
        double dy = vector.m_7098_() - ((double)pos.m_123342_() + 0.5);
        double dz = vector.m_7094_() - ((double)pos.m_123343_() + 0.5);
        double myDistW = dx * dx + dz * dz;
        return myDistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static void scheduleTickOverridingExisting(ServerLevel level, BlockPos pos, Block block, int delay) {
        ScheduledTick tick = new ScheduledTick((Object)block, pos, level.m_46467_() + (long)delay, level.m_183596_());
        long l = ChunkPos.m_151388_((BlockPos)tick.f_193377_());
        LevelChunkTicks container = (LevelChunkTicks)level.m_183326_().f_193202_.get(l);
        container.m_193183_(t -> t.f_193377_().equals((Object)tick.f_193377_()) && t.f_193376_() == tick.f_193376_());
        container.m_183393_(tick);
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public float getCandyWrappingIndex() {
            return switch (this) {
                case HALLOWEEN -> 0.5f;
                case CHRISTMAS -> 1.0f;
                default -> 0.0f;
            };
        }

        private static Festivity get() {
            if (PlatHelper.getPhysicalSide().isClient() && ClientConfigs.General.UNFUNNY.get().booleanValue()) {
                return NONE;
            }
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date == 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 20) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

