/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CurseLootFunction
extends LootItemConditionalFunction {
    private static final List<Enchantment> CURSES = new ArrayList<Enchantment>();
    final double chance;

    public static void rebuild() {
        for (Enchantment e : BuiltInRegistries.f_256876_) {
            if (!e.m_6589_() || BuiltInRegistries.f_256876_.m_263177_((Object)e).m_203656_(ModTags.CURSES_BLACKLIST)) continue;
            CURSES.add(e);
        }
    }

    CurseLootFunction(LootItemCondition[] pConditions, double chance) {
        super(pConditions);
        this.chance = chance;
    }

    public LootItemFunctionType m_7162_() {
        return ModRegistry.CURSE_LOOT_FUNCTION.get();
    }

    public ItemStack m_7372_(ItemStack pStack, LootContext pContext) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)pStack);
        RandomSource random = pContext.m_230907_();
        if ((double)random.m_188501_() < this.chance) {
            if (CURSES.stream().noneMatch(map::containsKey) && !CURSES.isEmpty()) {
                Enchantment e = CURSES.get(random.m_188503_(CURSES.size()));
                map.put(e, 1);
            }
        }
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)pStack);
        return pStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CurseLootFunction> {
        public void serialize(JsonObject jsonObject, CurseLootFunction function, JsonSerializationContext context) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)function, context);
            jsonObject.addProperty("chance", (Number)function.chance);
        }

        public CurseLootFunction deserialize(JsonObject pObject, JsonDeserializationContext context, LootItemCondition[] pConditions) {
            double chance = GsonHelper.m_144742_((JsonObject)pObject, (String)"chance", (double)1.0);
            return new CurseLootFunction(pConditions, chance);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final double chance;

        public Builder() {
            this(1.0);
        }

        public Builder(double chance) {
            this.chance = chance;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new CurseLootFunction(this.m_80699_(), this.chance);
        }
    }
}

