/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeBlock
extends WaterBlock
implements EntityBlock,
IWashable {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty ROTATION = ModBlockProperties.ROTATION_4;

    public GlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void displayCurrentCoordinates(Level level, Player player, BlockPos pos) {
        Object x = String.valueOf(pos.m_123341_());
        Object z = String.valueOf(pos.m_123343_());
        if (!level.m_6042_().f_63858_()) {
            x = ChatFormatting.OBFUSCATED + (String)x + ChatFormatting.RESET;
            z = ChatFormatting.OBFUSCATED + (String)z + ChatFormatting.RESET;
        }
        player.m_5661_((Component)Component.m_237110_((String)"message.supplementaries.compass", (Object[])new Object[]{x, z}), true);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        this.updatePower(state, worldIn, pos);
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            tile.setCustomName(stack.m_41786_());
        }
    }

    public void updatePower(BlockState state, Level leve, BlockPos pos) {
        boolean powered;
        boolean bl = powered = leve.m_277086_(pos) > 0;
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            leve.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 4);
            if (powered) {
                leve.m_142346_(null, GameEvent.f_223702_, pos);
                leve.m_7696_(pos, state.m_60734_(), 1, 0);
            }
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        GlobeBlockTile tile;
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile && (tile = (GlobeBlockTile)blockEntity).m_8077_()) {
            stack.m_41714_(tile.m_7770_());
        }
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            if (player.m_21120_(handIn).m_41720_() instanceof ShearsItem) {
                tile.toggleShearing();
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(player, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    level.m_7696_(pos, state.m_60734_(), 2, 0);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.f_46443_) {
                if (tile.isSpinningVeryFast() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Advancement advancement = level.m_7654_().m_129889_().m_136041_(new ResourceLocation("supplementaries", "adventure/globe"));
                    if (advancement != null && !serverPlayer.m_8960_().m_135996_(advancement).m_8193_()) {
                        serverPlayer.m_8960_().m_135988_(advancement, "unlock");
                    }
                }
                level.m_142346_((Entity)player, GameEvent.f_223702_, pos);
                level.m_7696_(pos, state.m_60734_(), 1, 0);
            } else if (ClientConfigs.Blocks.GLOBE_COORDINATES.get().booleanValue()) {
                GlobeBlock.displayCurrentCoordinates(level, player, pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (MiscUtils.FESTIVITY.isEarthDay() && level.f_46443_) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (int l = 0; l < 1; ++l) {
                double d0 = (double)x + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.625;
                double d1 = (double)y + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.625;
                double d2 = (double)z + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.625;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return GlobeBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, POWERED, ROTATION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GlobeBlockTile(pPos, pState);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(eventID, eventParam);
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            return tile.getSignalPower();
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.GLOBE_TILE.get(), GlobeBlockTile::tick);
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        GlobeBlockTile tile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlobeBlockTile && (tile = (GlobeBlockTile)blockEntity).isSepia()) {
            level.m_46597_(pos, ModRegistry.GLOBE.get().m_152465_(state));
            return true;
        }
        return false;
    }
}

