/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import toni.immersivelanterns.AccessoriesLanternRenderer;
import toni.immersivelanterns.LanternCurioRenderer;
import toni.immersivelanterns.foundation.config.AllConfigs;
import toni.lib.utils.PlatformUtils;

@Mod(value="immersivelanterns")
public class ImmersiveLanterns {
    public static final String MODNAME = "Immersive Lanterns";
    public static final String ID = "immersivelanterns";

    public ImmersiveLanterns() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec));
    }

    public static boolean isEquipped(Player player) {
        if (PlatformUtils.isModLoaded((String)"accessories")) {
            return AccessoriesLanternRenderer.isEquipped(player);
        }
        return LanternCurioRenderer.isEquipped(player);
    }

    public static ItemStack getEquipped(Player player) {
        if (!ImmersiveLanterns.isEquipped(player)) {
            return null;
        }
        if (PlatformUtils.isModLoaded((String)"accessories")) {
            return AccessoriesLanternRenderer.getEquipped(player);
        }
        return LanternCurioRenderer.getEquipped(player);
    }

    public void onInitialize() {
    }

    public void onInitializeClient() {
        if (PlatformUtils.isModLoaded((String)"accessories")) {
            AccessoriesLanternRenderer.register();
        } else {
            LanternCurioRenderer.register();
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

