/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.client.renderer;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.protect_your_moa.capability.armor.MoaArmor;
import com.aetherteam.protect_your_moa.item.ProtectItems;
import com.mojang.blaze3d.platform.Window;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether_protect_your_moa", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ProtectOverlays {
    private static final ResourceLocation TEXTURE_JUMPS = new ResourceLocation("aether_protect_your_moa", "textures/gui/jumps_gravitite.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("moa_jumps_gravitite", (gui, graphics, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                ProtectOverlays.renderMoaJumps(graphics, window, player);
            }
        });
    }

    private static void renderMoaJumps(GuiGraphics guiGraphics, Window window, LocalPlayer player) {
        Entity entity = player.m_20202_();
        if (entity instanceof Moa) {
            MoaArmor moaArmor;
            Optional moaArmorOptional;
            Moa moa = (Moa)entity;
            int jumps = moa.getMaxJumps() - 3;
            LazyOptional<MoaArmor> moaArmorLazyOptional = MoaArmor.get(moa);
            if (moaArmorLazyOptional.isPresent() && (moaArmorOptional = moaArmorLazyOptional.resolve()).isPresent() && (moaArmor = (MoaArmor)moaArmorOptional.get()).getArmor() != null && moaArmor.getArmor().m_150930_((Item)ProtectItems.GRAVITITE_MOA_ARMOR.get())) {
                for (int jumpCount = jumps; jumpCount < moa.getMaxJumps(); ++jumpCount) {
                    int xPos = window.m_85445_() / 2 + jumpCount * 8 - moa.getMaxJumps() * 8 / 2;
                    int yPos = 18;
                    if (jumpCount < moa.getRemainingJumps()) {
                        guiGraphics.m_280163_(TEXTURE_JUMPS, xPos, yPos, 0.0f, 0.0f, 9, 11, 256, 256);
                        continue;
                    }
                    guiGraphics.m_280163_(TEXTURE_JUMPS, xPos, yPos, 10.0f, 0.0f, 9, 11, 256, 256);
                }
            }
        }
    }
}

