/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.capability.armor;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import com.aetherteam.protect_your_moa.capability.armor.MoaArmor;
import com.aetherteam.protect_your_moa.inventory.menu.MoaInventoryMenu;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import com.aetherteam.protect_your_moa.network.ProtectPacketHandler;
import com.aetherteam.protect_your_moa.network.packet.MoaArmorSyncPacket;
import com.aetherteam.protect_your_moa.network.packet.clientbound.OpenMoaInventoryPacket;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Triple;

public class MoaArmorCapability
implements MoaArmor,
ContainerListener {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("F7EC75AF-718C-45BF-99E8-ADFF0BCAB659");
    private final Moa moa;
    private boolean chested;
    private SimpleContainer inventory;
    private boolean shouldSyncChest;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("equipSaddle", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.equipSaddle(), this::isSaddled)), Map.entry("equipArmor", Triple.of((Object)INBTSynchable.Type.ITEM_STACK, object -> this.equipArmor((ItemStack)object), this::getArmor)), Map.entry("setChest", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setChest((Boolean)object), this::hasChest)), Map.entry("setShouldSyncChest", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldSyncChest((Boolean)object), this::shouldSyncChest)));

    public MoaArmorCapability(Moa moa) {
        this.moa = moa;
        this.createInventory();
    }

    @Override
    public Moa getMoa() {
        return this.moa;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.getInventory().m_8020_(0).m_41619_()) {
            tag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.getInventory().m_8020_(1).m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        tag.m_128379_("Chested", this.hasChest());
        if (this.hasChest()) {
            ListTag list = new ListTag();
            for (int i = 2; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(slotTag);
                list.add((Object)slotTag);
            }
            tag.m_128365_("Items", (Tag)list);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ItemStack itemstack;
        ItemStack itemStack;
        if (tag.m_128425_("SaddleItem", 10) && (itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.getInventory().m_6836_(0, itemStack);
        }
        if (tag.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemstack)) {
            this.getInventory().m_6836_(1, itemstack);
        }
        this.setChest(tag.m_128471_("Chested"));
        if (this.hasChest()) {
            ListTag list = tag.m_128437_("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compoundtag = list.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        this.updateContainerEquipment();
    }

    @Override
    public void onJoinLevel() {
        if (this.getMoa().m_9236_().m_5776_()) {
            this.setSynched(INBTSynchable.Direction.SERVER, "setShouldSyncChest", true);
        }
    }

    @Override
    public void onUpdate() {
        this.syncChest();
    }

    private void syncChest() {
        if (!this.getMoa().m_9236_().m_5776_() && this.shouldSyncChest()) {
            this.setSynched(INBTSynchable.Direction.CLIENT, "setChest", this.hasChest());
            this.setShouldSyncChest(false);
        }
    }

    public void m_5757_(Container container) {
        ItemStack oldArmorStack = this.getArmor();
        boolean oldSaddled = this.isSaddled();
        this.updateContainerEquipment();
        if (this.getMoa().f_19797_ > 20 && !oldSaddled && this.isSaddled()) {
            this.getMoa().m_5496_(this.getMoa().m_246265_(), 0.5f, 1.0f);
        }
        ItemStack newArmorStack = this.getArmor();
        if (this.getMoa().f_19797_ > 20 && this.isArmor(newArmorStack) && oldArmorStack != newArmorStack) {
            this.getMoa().m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    private void updateContainerEquipment() {
        if (!this.getMoa().m_9236_().m_5776_()) {
            this.getMoa().setSaddled(!this.getInventory().m_8020_(0).m_41619_());
            this.setArmorEquipment(this.inventory.m_8020_(1));
            this.getMoa().m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        AttributeInstance armorAttribute;
        this.setArmor(stack);
        if (!this.getMoa().m_9236_().m_5776_() && (armorAttribute = this.getMoa().m_21051_(Attributes.f_22284_)) != null) {
            int protection;
            armorAttribute.m_22120_(ARMOR_MODIFIER_UUID);
            if (this.isArmor(stack) && (protection = ((MoaArmorItem)stack.m_41720_()).getProtection()) != 0) {
                armorAttribute.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    public void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
    }

    @Override
    public void openInventory(ServerPlayer serverPlayer, Moa moa) {
        if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
            serverPlayer.m_6915_();
        }
        serverPlayer.m_9217_();
        PacketRelay.sendToPlayer((SimpleChannel)ProtectPacketHandler.INSTANCE, (Object)new OpenMoaInventoryPacket(moa.m_19879_(), this.inventory.m_6643_(), serverPlayer.f_8940_), (ServerPlayer)serverPlayer);
        serverPlayer.f_36096_ = new MoaInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.inventory, moa);
        serverPlayer.m_143399_(serverPlayer.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
    }

    @Override
    public void equipSaddle() {
        this.getInventory().m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    @Override
    public boolean isSaddled() {
        return this.getMoa().m_6254_();
    }

    @Override
    public void equipArmor(ItemStack armor) {
        this.getInventory().m_6836_(1, armor.m_255036_(1));
    }

    @Override
    public void setArmor(ItemStack itemStack) {
        this.getMoa().m_8061_(EquipmentSlot.CHEST, itemStack);
        this.getMoa().m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    @Override
    public ItemStack getArmor() {
        return this.getMoa().m_6844_(EquipmentSlot.CHEST);
    }

    @Override
    public boolean isWearingArmor() {
        return !this.getMoa().m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    @Override
    public void setChest(boolean chested) {
        this.chested = chested;
        this.createInventory();
    }

    @Override
    public boolean hasChest() {
        return this.chested;
    }

    @Override
    public void setShouldSyncChest(boolean sync) {
        this.shouldSyncChest = sync;
    }

    @Override
    public boolean shouldSyncChest() {
        return this.shouldSyncChest;
    }

    @Override
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected int getInventorySize() {
        return this.hasChest() ? 17 : 2;
    }

    @Override
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof MoaArmorItem;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new MoaArmorSyncPacket(this.getMoa().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return ProtectPacketHandler.INSTANCE;
    }
}

