/*
 * Decompiled with CFR 0.152.
 */
package fuzs.climaterivers.handler;

import com.mojang.datafixers.util.Pair;
import fuzs.climaterivers.init.ModBiomes;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;

public class RiverBiomeBuilder {
    static final ParameterUtils.Temperature[] TEMPERATURES = new ParameterUtils.Temperature[]{ParameterUtils.Temperature.ICY, ParameterUtils.Temperature.COOL, ParameterUtils.Temperature.NEUTRAL, ParameterUtils.Temperature.WARM, ParameterUtils.Temperature.HOT};
    static final ParameterUtils.Humidity[] HUMIDITIES = new ParameterUtils.Humidity[]{ParameterUtils.Humidity.ARID, ParameterUtils.Humidity.DRY, ParameterUtils.Humidity.NEUTRAL, ParameterUtils.Humidity.WET, ParameterUtils.Humidity.HUMID};
    static final ResourceKey<Biome>[][] UNFROZEN_RIVERS = new ResourceKey[][]{{null, null, null, null, null}, {ModBiomes.COLD_RIVER_BIOME, ModBiomes.COLD_RIVER_BIOME, ModBiomes.COLD_RIVER_BIOME, ModBiomes.COLD_RIVER_BIOME, ModBiomes.COLD_RIVER_BIOME}, {Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_, Biomes.f_48208_}, {ModBiomes.WARM_RIVER_BIOME, ModBiomes.WARM_RIVER_BIOME, Biomes.f_48208_, ModBiomes.LUKEWARM_RIVER_BIOME, ModBiomes.LUKEWARM_RIVER_BIOME}, {ModBiomes.WARM_RIVER_BIOME, ModBiomes.WARM_RIVER_BIOME, ModBiomes.WARM_RIVER_BIOME, ModBiomes.WARM_RIVER_BIOME, ModBiomes.WARM_RIVER_BIOME}};

    public static void addRivers(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset) {
        for (int temperature = 0; temperature < TEMPERATURES.length; ++temperature) {
            for (int humidity = 0; humidity < HUMIDITIES.length; ++humidity) {
                ResourceKey<Biome> biome = UNFROZEN_RIVERS[temperature][humidity];
                if (biome == null) continue;
                RiverBiomeBuilder.addSurfaceBiome(mapper, TEMPERATURES[temperature].parameter(), HUMIDITIES[humidity].parameter(), continentalness, erosion, weirdness, offset, biome);
            }
        }
    }

    static void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)ParameterUtils.Depth.SURFACE.parameter(), (Climate.Parameter)weirdness, (float)offset), biome));
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)ParameterUtils.Depth.FLOOR.parameter(), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

