/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.mehvahdjukaar.every_compat.modules.storagedrawers.StorageDrawersModule;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

public class ModDrawersGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData(StorageDrawersModule module, ResourceManager manager) {
        if (geometryDataLoaded) {
            return;
        }
        geometryDataLoaded = true;
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_icon_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_count_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_ind_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_indbase_area_1.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_icon_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_count_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_ind_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_indbase_area_2.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_icon_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_count_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_ind_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_drawers_indbase_area_4.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_icon_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_count_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_ind_area_1.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_indbase_area_1.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_icon_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_count_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_ind_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_indbase_area_2.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_icon_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_count_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_ind_area_4.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_drawers_indbase_area_4.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_icon_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_count_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_ind_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_icon_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_count_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_ind_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_icon_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_count_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_ind_area_2.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        ModDrawersGeometry.populateGeometryData(ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_icon_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_count_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_ind_area_3.json"), ModDrawersGeometry.modLoc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), manager, (BlockDrawers[])module.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new));
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("storagedrawers", path);
    }

    private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, ResourceManager manager, BlockDrawers ... blocks) {
        BlockModel slotInfo = ModDrawersGeometry.getBlockModel(locationIcon, manager);
        BlockModel countInfo = ModDrawersGeometry.getBlockModel(locationCount, manager);
        BlockModel indInfo = ModDrawersGeometry.getBlockModel(locationInd, manager);
        BlockModel indBaseInfo = ModDrawersGeometry.getBlockModel(locationIndBase, manager);
        for (BlockDrawers block : blocks) {
            Vector3f to;
            Vector3f from;
            int i;
            if (block == null) continue;
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111308_;
                to = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111309_;
                block.labelGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111308_;
                to = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111309_;
                block.countGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111308_;
                to = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111309_;
                block.indGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111308_;
                to = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111309_;
                block.indBaseGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockModel getBlockModel(ResourceLocation location, ResourceManager manager) {
        InputStreamReader reader = null;
        try {
            Resource iresource = manager.m_215593_(location);
            reader = new InputStreamReader(iresource.m_215507_(), StandardCharsets.UTF_8);
            BlockModel blockModel = BlockModel.m_111461_((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            return blockModel;
        }
        catch (IOException e) {
            BlockModel blockModel = null;
            return blockModel;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }
}

