/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.valhelsia;

import com.mojang.blaze3d.platform.NativeImage;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.core.init.ModRecipes;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.modules.forge.valhelsia.AxeCraftingRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;

public class ValhelsiaStructuresModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> cutStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> cutPosts;
    public final SimpleEntrySet<WoodType, Block> bundledStrippedPosts;
    public final SimpleEntrySet<WoodType, Block> bundledPosts;

    public ValhelsiaStructuresModule(String modId) {
        super(modId, "vs");
        ResourceLocation tab = this.modRes("main");
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "stripped", this.getModBlock("stripped_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new PostBlock(ValhelsiaStructuresModule.postProperties(woodType))).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.strippedPosts);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", this.getModBlock("oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new StrippablePostBlock((WoodType)woodType, ValhelsiaStructuresModule.postProperties(woodType))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.posts);
        this.cutStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut_stripped", this.getModBlock("cut_stripped_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new CutPostBlock(ValhelsiaStructuresModule.cutPostProperties(woodType))).requiresFromMap(this.strippedPosts.blocks)).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutStrippedPosts);
        this.cutPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "post", "cut", this.getModBlock("cut_oak_post"), () -> VanillaWoodTypes.OAK, woodType -> new StrippableCutPostBlock((WoodType)woodType, ValhelsiaStructuresModule.cutPostProperties(woodType))).requiresFromMap(this.posts.blocks)).addTag(this.modRes("cut_posts"), Registries.f_256747_)).addTag(this.modRes("cut_posts"), Registries.f_256913_)).setTabKey(tab)).defaultRecipe().copyParentDrop().setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.cutPosts);
        this.bundledStrippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled_stripped", this.getModBlock("bundled_stripped_oak_posts"), () -> VanillaWoodTypes.OAK, woodType -> new RotatedPillarBlock(ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresFromMap(this.strippedPosts.blocks)).requiresChildren(new String[]{"stripped_log"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledStrippedPosts);
        this.bundledPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "posts", "bundled", this.getModBlock("bundled_oak_posts"), () -> VanillaWoodTypes.OAK, woodType -> new StrippableRotatedPillarBlock(() -> (Block)this.bundledStrippedPosts.blocks.get(woodType), ValhelsiaStructuresModule.bundledPostProperties(woodType))).requiresFromMap(this.posts.blocks)).requiresFromMap(this.bundledStrippedPosts.blocks)).addTag(BlockTags.f_144280_, Registries.f_256747_)).setTabKey(tab)).defaultRecipe().build();
        this.addEntry(this.bundledPosts);
    }

    public static BlockBehaviour.Properties postProperties(WoodType woodType) {
        return woodType.copyProperties().m_284180_(Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).m_284356_() : woodType.log.m_284356_()).m_60978_(2.0f).m_60955_();
    }

    public static BlockBehaviour.Properties cutPostProperties(WoodType woodType) {
        return woodType.copyProperties().m_284495_(state -> ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_() == Direction.Axis.Y && Objects.nonNull(woodType.getBlockOfThis("stripped_log")) ? Objects.requireNonNull(woodType.getBlockOfThis("stripped_log")).m_284356_() : woodType.log.m_284356_()).m_60978_(2.0f).m_60955_();
    }

    public static BlockBehaviour.Properties bundledPostProperties(WoodType woodType) {
        return woodType.copyProperties().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? MapColor.f_283825_ : MapColor.f_283819_);
    }

    @Override
    public void onModSetup() {
        TemplateRecipeManager.registerTemplate((RecipeSerializer)((RecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get()), AxeCraftingRecipeTemplate::new);
        super.onModSetup();
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            try {
                this.posts.blocks.forEach((w, block) -> {
                    ResourceLocation id = Utils.getID((Block)block);
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.log, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                        TextureImage newTexture = logTexture.makeCopy();
                        sink.addTextureIfNotPresent(manager, newId, () -> newTexture);
                        TextureImage newTop = topTexture.makeCopy();
                        CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                        sink.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate Post texture for for {} : {}", block, (Object)e);
                    }
                });
                this.strippedPosts.blocks.forEach((w, block) -> {
                    ResourceLocation id = Utils.getID((Block)block);
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage topTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.getBlockOfThis("stripped_log"), CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/post/stripped_oak_post", (BlockType)w, (ResourceLocation)id, (String)"oak");
                        try (TextureImage newTexture = logTexture.makeCopy();
                             TextureImage newTop = topTexture.makeCopy();){
                            sink.addTextureIfNotPresent(manager, newId, () -> newTexture);
                            CompatSpritesHelper.createSmallLogTopTexture(topTexture, newTop);
                            sink.addTextureIfNotPresent(manager, newId + "_top", () -> newTop);
                        }
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to generate Stripped-Post texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception ex) {
                EveryCompat.LOGGER.error("Could not generate block texture: ", (Throwable)ex);
            }
            try (TextureImage BPTopInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_inner_m"));
                 TextureImage BPTopOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/vs/bundledposts_top_outer_m"));
                 TextureImage logInnerMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/common_log_top_inner_m"));
                 TextureImage logOuterMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/common_log_top_outer_m"));){
                this.bundledPosts.blocks.forEach((w, block) -> {
                    String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_" + w.getTypeName() + "_posts";
                    this.createTexture(newPath, w.log, logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_oak_posts"), this.modRes("block/bundled_posts/bundled_oak_posts_top"), sink, manager, (Block)block);
                });
                this.bundledStrippedPosts.blocks.forEach((w, block) -> {
                    String newPath = "block/" + this.shortenedId() + "/" + w.getNamespace() + "/bundled_posts/bundled_stripped_" + w.getTypeName() + "_posts";
                    this.createTexture(newPath, w.getBlockOfThis("stripped_log"), logInnerMask, logOuterMask, BPTopInnerMask, BPTopOuterMask, this.modRes("block/bundled_posts/bundled_stripped_oak_posts"), this.modRes("block/bundled_posts/bundled_stripped_oak_posts_top"), sink, manager, (Block)block);
                });
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to open bundled_posts texture: ", (Throwable)e);
            }
        });
    }

    private void createTexture(String newPath, Block getLogBlock, TextureImage logInnerMask, TextureImage logOuterMask, TextureImage BPTopInnerMask, TextureImage BPTopOuterMask, ResourceLocation getLogSide, ResourceLocation getLogTop, ResourceSink sink, ResourceManager manager, Block block) {
        try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
             TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)getLogBlock, CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));
             TextureImage TextureSide = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogSide);
             TextureImage TextureTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)getLogTop);){
            TextureImage topImage;
            TextureImage sideImage;
            NativeImage standardSize;
            McMetaFile metaSide = logSide_texture.getMcMeta();
            if (Objects.nonNull(logSide_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.m_85054_(logSide_texture.getImage());
                sideImage = TextureImage.of((NativeImage)standardSize);
            } else {
                sideImage = logSide_texture;
            }
            List targetSide = Palette.fromAnimatedImage((TextureImage)sideImage);
            Respriter respriterSide = Respriter.of((TextureImage)TextureSide);
            sink.addTextureIfNotPresent(manager, newPath, () -> respriterSide.recolorWithAnimation(targetSide, metaSide));
            McMetaFile metaTop = logTop_texture.getMcMeta();
            if (Objects.nonNull(logTop_texture.getMcMeta())) {
                standardSize = new NativeImage(16, 16, false);
                standardSize.m_85054_(logTop_texture.getImage());
                topImage = TextureImage.of((NativeImage)standardSize);
            } else {
                topImage = logTop_texture;
            }
            List targetTopInner = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logOuterMask, (float)0.0f);
            List targetTopOuter = Palette.fromAnimatedImage((TextureImage)topImage, (TextureImage)logInnerMask, (float)0.0f);
            Respriter innerTopResp = Respriter.masked((TextureImage)TextureTop, (TextureImage)BPTopOuterMask);
            TextureImage recoloredInner = innerTopResp.recolorWithAnimation(targetTopInner, metaTop);
            Respriter outerTopResp = Respriter.masked((TextureImage)recoloredInner, (TextureImage)BPTopInnerMask);
            while (((Palette)targetTopOuter.get(0)).size() < 3) {
                ((Palette)targetTopOuter.get(0)).increaseInner();
            }
            TextureImage recoloredOuter = outerTopResp.recolorWithAnimation(targetTopOuter, metaTop);
            sink.addTextureIfNotPresent(manager, newPath + "_top", () -> recoloredOuter);
            recoloredOuter.close();
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to generate the texture for {} : {}", (Object)block, (Object)e);
        }
    }

    public class StrippableCutPostBlock
    extends CutPostBlock {
        public final WoodType woodType;

        public StrippableCutPostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)this);
            if (!context.m_43722_().canPerformAction(toolAction) || Objects.requireNonNull(location).m_135815_().contains("stripped")) {
                return null;
            }
            if (toolAction == ToolActions.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull((Block)BuiltInRegistries.f_256975_.m_7745_(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.cutStrippedPosts.blocks.get(this.woodType))))).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ATTACHED, (Comparable)((Boolean)state.m_61143_((Property)ATTACHED)))).m_61124_((Property)PARTS, (Comparable)((Integer)state.m_61143_((Property)PARTS)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            }
            return null;
        }
    }

    public class StrippablePostBlock
    extends PostBlock {
        public final WoodType woodType;

        public StrippablePostBlock(WoodType woodType, BlockBehaviour.Properties properties) {
            super(properties);
            this.woodType = woodType;
        }

        public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)this);
            if (!context.m_43722_().canPerformAction(toolAction) || Objects.requireNonNull(location).m_135815_().contains("stripped")) {
                return null;
            }
            if (toolAction == ToolActions.AXE_STRIP && Objects.nonNull(ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))) {
                return (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.f_256975_.m_7745_(Utils.getID((Block)((Block)ValhelsiaStructuresModule.this.strippedPosts.blocks.get(this.woodType))))).m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_((Property)ATTACHED, (Comparable)((Boolean)state.m_61143_((Property)ATTACHED)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            }
            return null;
        }
    }
}

