/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class FarmersDelightModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> cabinets;
    public static final PaletteStrategy customPalette = PaletteStrategies.registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(blockType, manager, "planks", null, p -> {
        p.reduceDown();
        if (p.size() < 9) {
            while (p.size() <= 9) {
                p.increaseInner();
            }
        } else {
            while (p.size() >= 9) {
                p.reduce();
            }
        }
    }));
    private final Map<String, String> COMPAT_RECIPE_MODS = Map.ofEntries(Map.entry("aether", "fcaether"), Map.entry("betterend", "fcbe"), Map.entry("betternether", "fcbn"), Map.entry("biomesoplenty", "fcbop"), Map.entry("biomeswevegone", "fcbwg"), Map.entry("blue_skies", "fcbs"), Map.entry("cinderscapes", "fccs"), Map.entry("eternal_starlight", "fces"), Map.entry("natures_spirit", "fcns"), Map.entry("nethers_exoticism", "fcne"), Map.entry("promenade", "fcpromenade"), Map.entry("regions_unexplored", "fcru"), Map.entry("terrestria", "fcterrestria"), Map.entry("twilightforest", "fctf"));

    public FarmersDelightModule(String modId) {
        super(modId, "fd");
        this.cabinets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", this.getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK, w -> new CabinetBlock(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"trapdoor", "slab"})).addTile(this.getModTile("cabinet")).addTextureM(this.modRes("block/oak_cabinet_front"), EveryCompat.res("block/fd/oak_cabinet_front_m"), customPalette)).addTexture(this.modRes("block/oak_cabinet_side"), customPalette)).addTexture(this.modRes("block/oak_cabinet_top"), customPalette)).addTexture(this.modRes("block/oak_cabinet_front_open"), customPalette)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("cabinets/wooden"), Registries.f_256913_)).setTabKey(this.modRes("farmersdelight"))).setTabMode(TabAddMode.AFTER_SAME_TYPE)).defaultRecipe().build();
        this.addEntry(this.cabinets);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood(woodType)) continue;
                String namespaceRegex = this.COMPAT_RECIPE_MODS.getOrDefault(woodType.getNamespace(), "none");
                boolean isRecipeModNotInstalled = !PlatHelper.getInstalledMods().contains(namespaceRegex);
                if (!isRecipeModNotInstalled) continue;
                this.createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType.planks, woodType, handler, manager);
                this.createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType.planks, woodType, handler, manager);
                this.createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType.planks, woodType, handler, manager);
                this.createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType.planks, woodType, handler, manager);
                this.createCuttingRecipe("log", woodType.log, woodType.getBlockOfThis("stripped_log"), woodType, handler, manager);
                this.createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"), woodType, handler, manager);
            }
        });
    }

    public void createCuttingRecipe(String recipeType, Block input, Block output, WoodType woodType, ResourceSink handler, ResourceManager manager) {
        if (Objects.nonNull(input) && Objects.nonNull(output)) {
            ResourceLocation recipeLocation = this.modRes("recipes/cutting/oak_" + recipeType + ".json");
            try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLocation).orElseThrow(() -> new FileNotFoundException(recipeLocation.toString()))).m_215507_();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                JsonObject getItem = recipe.getAsJsonArray("ingredients").get(0).getAsJsonObject();
                getItem.addProperty("item", Utils.getID((Block)input).toString());
                JsonObject getResult = recipe.getAsJsonArray("result").get(0).getAsJsonObject();
                getResult.addProperty("item", Utils.getID((Block)output).toString());
                String path = this.shortenedId() + "/cutting/" + woodType.getAppendableId() + "_" + recipeType;
                handler.addJson(EveryCompat.res(path), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the cutting recipe for {} - {}", (Object)Utils.getID((Block)output), (Object)e);
            }
        }
    }
}

