/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ErrorMessageScreen;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EveryCompatClient {
    public static void init() {
        ClientHelper.addClientSetup(EveryCompatClient::clientSetup);
        EveryCompat.forAllModules(CompatModule::onClientInit);
        ClientHelper.addBlockEntityRenderersRegistration(EveryCompatClient::registerBlockEntityRenderers);
        ClientHelper.addBlockColorsRegistration(EveryCompatClient::registerBlockColors);
        ClientHelper.addItemColorsRegistration(EveryCompatClient::registerItemColors);
        ClientDynamicResourcesHandler.getInstance().register();
    }

    public static void onFirstScreen(Screen screen) {
        Map<String, String> errors = EveryCompat.getModulesThatErrored();
        if (!errors.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)ErrorMessageScreen.create(screen, errors));
        }
        EveryCompat.canShowErrorScreen = false;
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockColors(event));
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerItemColors(event));
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockEntityRenderers(event));
    }

    public static void clientSetup() {
        EveryCompat.forAllModules(CompatModule::onClientSetup);
    }

    public static void onItemTooltip(ItemStack stack, TooltipFlag tooltipFlag, List<Component> components) {
        Item item;
        CompatModule compatModule;
        boolean modTooltip = ECConfigs.MOD_TOOPTIP.get();
        boolean blockTooltip = ECConfigs.BLOCK_TYPE_TOOLTIP.get();
        if ((modTooltip || blockTooltip && (tooltipFlag.m_7050_() || !ECConfigs.TOOLTIPS_ADVANCED.get().booleanValue())) && (compatModule = EveryCompat.getModuleOfItem(item = stack.m_41720_())) != null) {
            if (blockTooltip) {
                BlockType leavesType;
                BlockType woodType = WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)item);
                if (woodType != null) {
                    components.add((Component)Component.m_237110_((String)"tooltip.everycomp.wood_type", (Object[])new Object[]{woodType.toString()}).m_130940_(ChatFormatting.DARK_GREEN));
                }
                if ((leavesType = LeavesTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)item)) != null) {
                    components.add((Component)Component.m_237110_((String)"tooltip.everycomp.leaf_type", (Object[])new Object[]{leavesType.toString()}).m_130940_(ChatFormatting.DARK_GREEN));
                }
            }
            if (modTooltip) {
                components.add((Component)Component.m_237110_((String)"tooltip.everycomp.mod", (Object[])new Object[]{compatModule.getModName()}).m_130940_(ChatFormatting.BLUE));
            }
        }
        if (PlatHelper.isDev()) {
            Block blocked = Block.m_49814_((Item)stack.m_41720_());
            if (blocked != Blocks.f_50016_) {
                components.add((Component)Component.m_237113_((String)"BlockTag:").m_130940_(ChatFormatting.GREEN));
                blocked.m_49966_().m_204343_().forEach(k -> components.add((Component)Component.m_237113_((String)("-" + k.f_203868_())).m_130948_(Style.f_131099_.m_178520_(0xC8FFC8))));
            }
            components.add((Component)Component.m_237113_((String)"ItemTag:").m_130940_(ChatFormatting.LIGHT_PURPLE));
            stack.m_204131_().forEach(k -> components.add((Component)Component.m_237113_((String)("-" + k.f_203868_())).m_130948_(Style.f_131099_.m_178520_(0xFFC8FF))));
        }
    }

    public static <B extends Block> void registerRenderType(B b, BlockType bt, Object type) {
        if (bt.id.equals((Object)ResourceLocation.m_135820_((String)"rats:pirat"))) {
            type = RenderLayer.TRANSLUCENT;
        }
        if (type == null) {
            return;
        }
        if (type instanceof RenderLayer) {
            RenderLayer rl = (RenderLayer)((Object)type);
            switch (rl) {
                case CUTOUT: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.m_110463_());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.m_110457_());
                    break;
                }
                case TRANSLUCENT: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.m_110466_());
                    break;
                }
                case SOLID: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.m_110451_());
                }
            }
        } else if (type instanceof Supplier) {
            Supplier s = (Supplier)type;
            RenderType renderType = (RenderType)((Supplier)s.get()).get();
            ClientHelper.registerRenderType(b, (RenderType)renderType);
        } else if (PlatHelper.isDev()) {
            throw new IllegalArgumentException("Invalid render type: " + type);
        }
    }
}

