/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.mixin;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import me.khajiitos.worldplaytime.common.util.IWithPlayTime;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.class})
public class LevelStorageSourceMixin {
    @Inject(at={@At(value="RETURN")}, method={"lambda$levelSummaryReader$5", "method_29015", "m_289842_"}, remap=false)
    public void onReturnLevelSummary(LevelStorageSource.LevelDirectory levelDirectory, boolean idk, Path path, DataFixer dataFixer, CallbackInfoReturnable<LevelSummary> cir) {
        LevelSummary levelSummary = (LevelSummary)cir.getReturnValue();
        if (levelSummary instanceof IWithPlayTime) {
            File[] saveFiles;
            IWithPlayTime withPlayTime = (IWithPlayTime)levelSummary;
            Path stats = path.getParent().resolve("stats");
            File statsFile = stats.toFile();
            if (statsFile.isDirectory() && (saveFiles = statsFile.listFiles()) != null) {
                int totalPlayTime = 0;
                for (File file : saveFiles) {
                    try (FileReader fileReader = new FileReader(file);){
                        JsonObject customObject;
                        JsonObject statsObject;
                        JsonObject jsonObject = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
                        if (!jsonObject.has("stats") || !(statsObject = jsonObject.getAsJsonObject("stats")).has("minecraft:custom") || !(customObject = statsObject.getAsJsonObject("minecraft:custom")).has("minecraft:play_time")) continue;
                        int playTime = customObject.get("minecraft:play_time").getAsInt();
                        totalPlayTime += playTime;
                    }
                    catch (JsonIOException | IOException | IllegalStateException throwable) {
                        // empty catch block
                    }
                }
                if (totalPlayTime > 0) {
                    withPlayTime.setPlayTimeTicks(totalPlayTime);
                }
            }
        }
    }
}

