/*
 * Decompiled with CFR 0.152.
 */
package toni.cerulean.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import toni.cerulean.Common;
import toni.cerulean.impl.StackSizeThresholdManager;

public class ReloadListenerHandlerBase
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String FOLDER = "advancements";

    public ReloadListenerHandlerBase() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        if (Common.config.OPTIMIZE_TRIGGERS_FOR_INCREASED_STACKS) {
            StackSizeThresholdManager.clear();
            String inventoryChangedTriggerId = CriteriaTriggers.f_10571_.m_7295_().toString();
            for (JsonElement advancementElement : object.values()) {
                JsonObject advancementCriteria = advancementElement.getAsJsonObject().getAsJsonObject("criteria");
                if (advancementCriteria == null || advancementCriteria.isJsonNull()) continue;
                for (Map.Entry criterionEntry : advancementCriteria.entrySet()) {
                    JsonObject criterion = ((JsonElement)criterionEntry.getValue()).getAsJsonObject();
                    JsonElement criterionTrigger = criterion.get("trigger");
                    JsonObject criterionConditions = criterion.getAsJsonObject("conditions");
                    if (criterionTrigger == null || criterionConditions == null || criterionTrigger.isJsonNull() || criterionConditions.isJsonNull() || !criterionTrigger.getAsString().equals(inventoryChangedTriggerId) || !criterionConditions.has("items")) continue;
                    for (JsonElement itemElement : criterionConditions.getAsJsonArray("items")) {
                        JsonElement itemCount = itemElement.getAsJsonObject().get("count");
                        if (itemCount == null || itemCount.isJsonNull()) continue;
                        int itemCountMinValue = 0;
                        if (itemCount.isJsonObject()) {
                            JsonElement itemCountMin = itemCount.getAsJsonObject().get("min");
                            if (itemCountMin != null && !itemCountMin.isJsonNull()) {
                                itemCountMinValue = itemCountMin.getAsInt();
                            }
                        } else {
                            itemCountMinValue = itemCount.getAsInt();
                        }
                        if (itemCountMinValue <= 1) continue;
                        StackSizeThresholdManager.add(itemCountMinValue);
                    }
                }
            }
            StackSizeThresholdManager.debugPrint();
        }
    }
}

