/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintLanguageProvider;
import com.teamabnormals.boatload.core.other.BoatloadUtil;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class BoatloadLanguageProvider
extends BlueprintLanguageProvider {
    public BoatloadLanguageProvider(PackOutput output) {
        super(output, "boatload");
    }

    protected void addTranslations() {
        this.add((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get(), "Boat with Furnace");
        this.add((EntityType)BoatloadEntityTypes.LARGE_BOAT.get(), "Large Boat");
        this.add(new Item[]{(Item)BoatloadItems.CRIMSON_BOAT.get()});
        this.add(new Item[]{(Item)BoatloadItems.WARPED_BOAT.get()});
        this.addChestBoat((Item)BoatloadItems.CRIMSON_CHEST_BOAT.get());
        this.addChestBoat((Item)BoatloadItems.WARPED_CHEST_BOAT.get());
        BoatloadUtil.getFurnaceBoats().forEach(this::addFurnaceBoat);
        BoatloadUtil.getLargeBoats().forEach(xva$0 -> this.add(new Item[]{xva$0}));
    }

    private void addChestBoat(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name).replace("Chest Boat", "Boat with Chest"));
        }
    }

    private void addFurnaceBoat(Item item) {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item);
        if (name != null) {
            this.add(item, this.format(name).replace("Furnace Boat", "Boat with Furnace"));
        }
    }
}

