/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core;

import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.boatload.client.model.FurnaceBoatModel;
import com.teamabnormals.boatload.client.model.FurnaceRaftModel;
import com.teamabnormals.boatload.client.model.LargeBoatModel;
import com.teamabnormals.boatload.client.model.WideRaftModel;
import com.teamabnormals.boatload.client.renderer.entity.FurnaceBoatRenderer;
import com.teamabnormals.boatload.client.renderer.entity.LargeBoatRenderer;
import com.teamabnormals.boatload.common.dispenser.FurnaceBoatDispenseItemBehavior;
import com.teamabnormals.boatload.common.dispenser.LargeBoatDispenseItemBehavior;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.data.client.BoatloadItemModelProvider;
import com.teamabnormals.boatload.core.data.client.BoatloadLanguageProvider;
import com.teamabnormals.boatload.core.data.server.BoatloadBlockTagsProvider;
import com.teamabnormals.boatload.core.data.server.BoatloadItemTagsProvider;
import com.teamabnormals.boatload.core.data.server.BoatloadRecipeProvider;
import com.teamabnormals.boatload.core.other.BoatloadModelLayers;
import com.teamabnormals.boatload.core.other.BoatloadTrackedData;
import com.teamabnormals.boatload.core.other.BoatloadUtil;
import com.teamabnormals.boatload.core.registry.BoatloadEntityTypes;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import com.teamabnormals.boatload.core.registry.helper.BoatloadItemSubRegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.BoatModel;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="boatload")
public class Boatload {
    public static final String MOD_ID = "boatload";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"boatload", helper -> helper.putSubHelper(ForgeRegistries.ITEMS, (ISubRegistryHelper)new BoatloadItemSubRegistryHelper((RegistryHelper)helper)));

    public Boatload() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        BoatloadEntityTypes.ENTITY_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
            BoatloadItems.setupTabEditors();
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BoatloadTrackedData.registerTrackedData();
        event.enqueueWork(() -> {
            BoatloadUtil.getFurnaceBoats().forEach(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)new FurnaceBoatDispenseItemBehavior(item.getType())));
            BoatloadUtil.getLargeBoats().forEach(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)new LargeBoatDispenseItemBehavior(item.getType())));
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        BoatloadBlockTagsProvider blockTags = new BoatloadBlockTagsProvider(output, lookupProvider, helper);
        generator.addProvider(includeServer, (DataProvider)blockTags);
        generator.addProvider(includeServer, (DataProvider)new BoatloadItemTagsProvider(output, lookupProvider, blockTags.m_274426_(), helper));
        generator.addProvider(includeServer, (DataProvider)new BoatloadRecipeProvider(output));
        boolean includeClient = event.includeClient();
        generator.addProvider(includeClient, (DataProvider)new BoatloadItemModelProvider(output, helper));
        generator.addProvider(includeClient, (DataProvider)new BoatloadLanguageProvider(output));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (BoatloadBoatType boatType : BoatloadBoatType.values()) {
            event.registerLayerDefinition(BoatloadModelLayers.createBoatModelName(boatType), BoatModel::m_246613_);
            event.registerLayerDefinition(BoatloadModelLayers.createFurnaceBoatModelName(boatType), boatType.raft() ? FurnaceRaftModel::createBodyModel : FurnaceBoatModel::createFurnaceBoatBodyModel);
            event.registerLayerDefinition(BoatloadModelLayers.createLargeBoatModelName(boatType), boatType.raft() ? WideRaftModel::createBodyModel : LargeBoatModel::createBodyModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BoatloadEntityTypes.FURNACE_BOAT.get(), FurnaceBoatRenderer::new);
        event.registerEntityRenderer((EntityType)BoatloadEntityTypes.LARGE_BOAT.get(), LargeBoatRenderer::new);
    }
}

