/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.data.server;

import com.teamabnormals.pet_cemetery.common.advancement.CuredZombiePetTrigger;
import com.teamabnormals.pet_cemetery.common.advancement.RespawnPetTrigger;
import com.teamabnormals.pet_cemetery.core.other.tags.PCEntityTypeTags;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class PCAdvancementProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    public static ForgeAdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new ForgeAdvancementProvider(output, provider, helper, List.of(new PCAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<Advancement> consumer, ExistingFileHelper helper) {
        ItemStack stack = new ItemStack((ItemLike)PCItems.PET_COLLAR.get());
        PCAdvancementProvider.createAdvancement("respawn_pet", "nether", new ResourceLocation("nether/charge_respawn_anchor"), stack, FrameType.TASK, true, true, false).m_138386_("respawn_pet", (CriterionTriggerInstance)RespawnPetTrigger.TriggerInstance.respawnPet()).m_138389_(consumer, "pet_cemetery:nether/respawn_pet");
        stack.m_41784_().m_128405_("CollarColor", DyeColor.GREEN.m_41060_());
        PCAdvancementProvider.createAdvancement("cured_zombie_pet", "nether", new ResourceLocation("pet_cemetery", "nether/respawn_pet"), stack, FrameType.GOAL, true, true, false).m_138386_("cured_zombie_pet", (CriterionTriggerInstance)CuredZombiePetTrigger.TriggerInstance.curedZombiePet()).m_138389_(consumer, "pet_cemetery:nether/cured_zombie_pet");
        stack.m_41784_().m_128405_("CollarColor", DyeColor.WHITE.m_41060_());
        PCAdvancementProvider.createAdvancement("respawn_zombie_pet", "nether", new ResourceLocation("pet_cemetery", "nether/respawn_pet"), stack, FrameType.TASK, true, true, false).m_138386_("respawn_zombie_pet", (CriterionTriggerInstance)RespawnPetTrigger.TriggerInstance.respawnPet(EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_204081_(PCEntityTypeTags.SKELETON_PETS)).m_36662_())).m_138389_(consumer, "pet_cemetery:nether/respawn_zombie_pet");
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemStack icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(Advancement.Builder.m_138353_().m_138403_(parent)).m_138362_(icon, (Component)Component.m_237115_((String)("advancements.pet_cemetery." + category + "." + name + ".title")), (Component)Component.m_237115_((String)("advancements.pet_cemetery." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }
}

