/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.item;

import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class PetCollarItem
extends Item {
    public PetCollarItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PetID")) {
            String petID = tag.m_128461_("PetID");
            EntityType pet = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(petID));
            MutableComponent petType = Component.m_237115_((String)pet.m_20675_()).m_130940_(ChatFormatting.GRAY);
            if (tag.m_128441_("PetVariant")) {
                String texture = "";
                if (pet == EntityType.f_20553_ || pet == PCEntityTypes.ZOMBIE_CAT.get()) {
                    ResourceLocation catVariant = new ResourceLocation(tag.m_128461_("PetVariant"));
                    texture = catVariant.m_135815_();
                }
                if (pet == EntityType.f_20508_ || pet == PCEntityTypes.ZOMBIE_PARROT.get()) {
                    texture = Parrot.Variant.m_262398_((int)tag.m_128451_("PetVariant")).m_7912_();
                }
                texture = texture.replace("_", " ").concat(" ");
                petType = Component.m_237113_((String)WordUtils.capitalize((String)texture)).m_130940_(ChatFormatting.GRAY).m_7220_((Component)petType);
            }
            if (tag.m_128471_("IsChild")) {
                petType = Component.m_237115_((String)"tooltip.pet_cemetery.baby").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)petType);
            }
            tooltip.add((Component)petType);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        DyeColor color = tag.m_128441_("CollarColor") ? DyeColor.m_41053_((int)tag.m_128451_("CollarColor")) : DyeColor.RED;
        float[] diffuseColors = color.m_41068_();
        return (((int)(diffuseColors[0] * 255.0f) << 8) + (int)(diffuseColors[1] * 255.0f) << 8) + (int)(diffuseColors[2] * 255.0f);
    }
}

