/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.entity;

import com.teamabnormals.pet_cemetery.core.other.PCCriteriaTriggers;
import com.teamabnormals.pet_cemetery.core.other.PCUtil;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombieWolf
extends Wolf {
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ZombieWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int conversionTime;
    private UUID conversionStarter;

    public ZombieWolf(EntityType<? extends ZombieWolf> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Wolf.m_30425_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONVERTING, (Object)false);
    }

    public ZombieWolf getBreedOffspring(ServerLevel world, AgeableMob entity) {
        ZombieWolf wolf = (ZombieWolf)((EntityType)PCEntityTypes.ZOMBIE_WOLF.get()).m_20615_((Level)world);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            wolf.m_21816_(uuid);
            wolf.m_7105_(true);
        }
        return wolf;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.conversionStarter != null) {
            compound.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"));
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            int i = PCUtil.getConversionProgress((LivingEntity)this);
            this.conversionTime -= i;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20499_, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureZombie((ServerLevel)this.m_9236_());
            }
        }
        super.m_8119_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42436_) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startConverting(player.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(CONVERTING);
    }

    private void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn) {
        this.conversionStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
        this.m_20088_().m_135381_(CONVERTING, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, conversionTimeIn, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 16) {
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(id);
        }
    }

    private void cureZombie(ServerLevel world) {
        Player player;
        Wolf wolf = this.copyEntityData();
        wolf.m_6518_((ServerLevelAccessor)world, world.m_6436_(wolf.m_20183_()), MobSpawnType.CONVERSION, null, null);
        if (this.conversionStarter != null && (player = this.m_9236_().m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PCCriteriaTriggers.CURED_ZOMBIE_PET.trigger(serverPlayer, (Animal)this, (Animal)wolf);
        }
        wolf.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            world.m_5898_(null, 1027, this.m_20183_(), 0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)wolf);
    }

    public Wolf copyEntityData() {
        Wolf wolf = (Wolf)this.m_21406_(EntityType.f_20499_, false);
        wolf.m_30397_(this.m_30428_());
        wolf.m_7105_(this.m_21824_());
        wolf.m_21839_(this.m_21827_());
        if (this.m_269323_() != null) {
            wolf.m_21816_(this.m_269323_().m_20148_());
        }
        return wolf;
    }
}

