/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.advancement;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class RespawnPetTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation("pet_cemetery", "respawn_pet");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject jsonObject, ContextAwarePredicate player, DeserializationContext context) {
        ContextAwarePredicate pet = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"pet", (DeserializationContext)context);
        ContextAwarePredicate respawnedPet = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"respawned_pet", (DeserializationContext)context);
        return new TriggerInstance(player, pet, respawnedPet);
    }

    public void trigger(ServerPlayer player, Animal pet, Animal respawnedPet) {
        LootContext petContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)pet);
        LootContext respawnedPetContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)respawnedPet);
        this.m_66234_(player, instance -> instance.matches(petContext, respawnedPetContext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ContextAwarePredicate pet;
        private final ContextAwarePredicate respawnedPet;

        public TriggerInstance(ContextAwarePredicate player, ContextAwarePredicate pet, ContextAwarePredicate respawnedPet) {
            super(ID, player);
            this.pet = pet;
            this.respawnedPet = respawnedPet;
        }

        public static TriggerInstance respawnPet() {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, ContextAwarePredicate.f_285567_, ContextAwarePredicate.f_285567_);
        }

        public static TriggerInstance respawnPet(EntityPredicate entity) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, ContextAwarePredicate.f_285567_, EntityPredicate.m_285787_((EntityPredicate)entity));
        }

        public boolean matches(LootContext petContext, LootContext respawnedPetContext) {
            if (!this.pet.m_285831_(petContext)) {
                return false;
            }
            return this.respawnedPet.m_285831_(respawnedPetContext);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            jsonObject.add("pet", this.pet.m_286026_(context));
            jsonObject.add("respawned_pet", this.respawnedPet.m_286026_(context));
            return jsonObject;
        }
    }
}

