/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.advancement;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class CuredZombiePetTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation("pet_cemetery", "cured_zombie_pet");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject jsonObject, ContextAwarePredicate player, DeserializationContext context) {
        ContextAwarePredicate zombie = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"zombie", (DeserializationContext)context);
        ContextAwarePredicate pet = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"pet", (DeserializationContext)context);
        return new TriggerInstance(player, zombie, pet);
    }

    public void trigger(ServerPlayer player, Animal zombie, Animal pet) {
        LootContext zombieContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)zombie);
        LootContext petContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)pet);
        this.m_66234_(player, instance -> instance.matches(zombieContext, petContext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ContextAwarePredicate zombie;
        private final ContextAwarePredicate pet;

        public TriggerInstance(ContextAwarePredicate player, ContextAwarePredicate zombie, ContextAwarePredicate pet) {
            super(ID, player);
            this.zombie = zombie;
            this.pet = pet;
        }

        public static TriggerInstance curedZombiePet() {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, ContextAwarePredicate.f_285567_, ContextAwarePredicate.f_285567_);
        }

        public boolean matches(LootContext zombieContext, LootContext petContext) {
            if (!this.zombie.m_285831_(zombieContext)) {
                return false;
            }
            return this.pet.m_285831_(petContext);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            jsonObject.add("zombie", this.zombie.m_286026_(context));
            jsonObject.add("pet", this.pet.m_286026_(context));
            return jsonObject;
        }
    }
}

