/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.structures;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class VillageWitchStructure
extends YungJigsawStructure {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 128;
    public static final Codec<VillageWitchStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)VillageWitchStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)IntProvider.m_146545_((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)ConstantInt.m_146483_((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)IntProvider.m_146545_((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)ConstantInt.m_146483_((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)builder, VillageWitchStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    public final int maxDepth;
    public final HeightProvider startHeight;
    public final IntProvider xOffsetInChunk;
    public final IntProvider zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;

    public VillageWitchStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, IntProvider xOffsetInChunk, IntProvider zOffsetInChunk, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        super(structureSettings, startPool, startJigsawName, maxDepth, startHeight, xOffsetInChunk, zOffsetInChunk, useExpansionHack, projectStartToHeightmap, maxBlockDistanceFromCenter, maxY, minY, enhancedTerrainAdaptation);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int offsetY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(context.f_226628_().m_45604_(), offsetY, context.f_226628_().m_45605_());
        if (!this.extraSpawningChecks(context, blockPos)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom randomSource = context.f_226626_();
        int xOffset = this.xOffsetInChunk.m_214085_((RandomSource)randomSource);
        int zOffset = this.zOffsetInChunk.m_214085_((RandomSource)randomSource);
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos startPos = new BlockPos(chunkPos.m_151382_(xOffset), startY, chunkPos.m_151391_(zOffset));
        return YungJigsawManager.assembleJigsawStructure((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)startPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, this.maxY, this.minY);
    }

    private boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        int checkRadius = 64;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int negativeFluidChecks = 0;
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                int x = xOffset + blockPos.m_123341_();
                int z = zOffset + blockPos.m_123343_();
                if (xOffset % checkRadius == 0 && zOffset % checkRadius == 0) {
                    Structure.GenerationStub structurePosition = new Structure.GenerationStub(new BlockPos(x, 68, z), collector -> {});
                    if (!this.isBiomeValid(structurePosition, context.f_226622_(), context.f_226624_(), arg_0 -> ((HolderSet)this.m_226559_()).m_203333_(arg_0))) {
                        return false;
                    }
                }
                NoiseColumn blockView = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
                mutable.m_122190_((Vec3i)blockPos).m_122184_(xOffset, -6, zOffset);
                if (!this.isViableBlockState(blockView.m_183556_(mutable.m_123342_())) || ++negativeFluidChecks <= 64) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isViableBlockState(BlockState blockState) {
        return !blockState.m_60819_().m_76178_() && blockState.m_60713_(Blocks.f_50016_);
    }

    private boolean isBiomeValid(Structure.GenerationStub result, ChunkGenerator chunkGenerator, RandomState noiseConfig, Predicate<Holder<Biome>> validBiomes) {
        BlockPos blockPos = result.f_226669_();
        return validBiomes.test((Holder<Biome>)chunkGenerator.m_62218_().m_203407_(QuartPos.m_175400_((int)blockPos.m_123341_()), QuartPos.m_175400_((int)blockPos.m_123342_()), QuartPos.m_175400_((int)blockPos.m_123343_()), noiseConfig.m_224579_()));
    }

    public StructureType<?> m_213658_() {
        return VillagesAndPillagesStructureTypes.VILLAGE_WITCH_STRUCTURE;
    }
}

