/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.processor;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesProcessorTypes;
import com.mojang.serialization.Codec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class VillageWitchBrewingStandProcessor
extends StructureProcessor {
    public static final VillageWitchBrewingStandProcessor INSTANCE = new VillageWitchBrewingStandProcessor();
    public static final Codec<VillageWitchBrewingStandProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader world, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlacementData) {
        if (!currentBlockInfo.f_74676_().m_60713_(Blocks.f_50255_)) {
            return currentBlockInfo;
        }
        RandomSource random = structurePlacementData.m_230326_(currentBlockInfo.f_74675_());
        CompoundTag nbt = currentBlockInfo.f_74677_();
        ListTag itemsListNbt = nbt.m_128437_("Items", 10);
        int randomNumber = random.m_216332_(0, 7);
        switch (randomNumber) {
            case 0: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:glistering_melon_slice", "minecraft:healing", random);
                break;
            }
            case 1: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:magma_cream", "minecraft:fire_resistance", random);
                break;
            }
            case 2: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:sugar", "minecraft:swiftness", random);
                break;
            }
            case 3: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:pufferfish", "minecraft:water_breathing", random);
                break;
            }
            case 4: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:fermented_spider_eye", "minecraft:slowness", random);
                break;
            }
            case 5: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:spider_eye", "minecraft:poison", random);
                break;
            }
            case 6: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:fermented_spider_eye", "minecraft:weakness", random);
                break;
            }
            case 7: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:fermented_spider_eye", "minecraft:harming", random);
            }
        }
        currentBlockInfo = new StructureTemplate.StructureBlockInfo(currentBlockInfo.f_74675_(), currentBlockInfo.f_74676_(), nbt);
        return currentBlockInfo;
    }

    private void addBrewingRecipe(ListTag itemsListTag, String inputItemId, String outputPotionId, RandomSource randomSource) {
        itemsListTag.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), itemTag -> this.putInputItem((CompoundTag)itemTag, inputItemId, (byte)(randomSource.m_188503_(3) + 2)))));
        itemsListTag.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), itemTag -> {
            this.putPotionInSlot((CompoundTag)itemTag, (byte)1, outputPotionId);
            if (randomSource.m_188501_() < 0.75f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)0, outputPotionId);
            }
            if (randomSource.m_188501_() < 0.5f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)2, outputPotionId);
            }
        })));
    }

    private void putInputItem(CompoundTag itemTag, String itemId, byte count) {
        itemTag.m_128344_("Slot", (byte)3);
        itemTag.m_128359_("id", itemId);
        itemTag.m_128344_("Count", count);
    }

    private void putPotionInSlot(CompoundTag itemTag, byte slot, String potionId) {
        itemTag.m_128344_("Slot", slot);
        itemTag.m_128359_("id", "minecraft:potion");
        itemTag.m_128344_("Count", (byte)1);
        itemTag.m_128365_("tag", (Tag)Util.m_137469_((Object)new CompoundTag(), potionTag -> potionTag.m_128359_("Potion", potionId)));
    }

    protected StructureProcessorType<?> m_6953_() {
        return VillagesAndPillagesProcessorTypes.VILLAGE_WITCH_BREWING_STAND_PROCESSOR;
    }
}

