/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class WorldGenRegistry<T> {
    protected final String modId;
    protected final ResourceKey<? extends Registry<T>> registry;

    private WorldGenRegistry(ResourceKey<? extends Registry<T>> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
    }

    public static <T> WorldGenRegistry<T> of(ResourceKey<? extends Registry<T>> registry, String modId) {
        return new WorldGenRegistry<T>(registry, modId);
    }

    public ResourceKey<T> create(String name) {
        return ResourceKey.m_135785_(this.registry, (ResourceLocation)new ResourceLocation(this.modId, name));
    }

    public void register(BootstapContext<T> context, ResourceKey<T> key, T entry) {
        context.m_255272_(key, entry);
    }

    public <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Feature<NoneFeatureConfiguration> feature) {
        this.register(context, key, feature, FeatureConfiguration.f_67737_);
    }

    public void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placements) {
        context.m_255272_(key, (Object)new PlacedFeature(feature, List.copyOf(placements)));
    }

    public void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placements) {
        this.register(context, key, feature, List.of(placements));
    }

    public void register(BootstapContext<NormalNoise.NoiseParameters> context, ResourceKey<NormalNoise.NoiseParameters> key, int firstOctave, double firstAmplitude, double ... amplitudes) {
        context.m_255272_(key, (Object)new NormalNoise.NoiseParameters(firstOctave, firstAmplitude, amplitudes));
    }

    public void register() {
    }
}

