/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.integration.forge;

import com.blackgear.platform.common.integration.TradeIntegration;
import com.blackgear.platform.common.integration.VillagerLevel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;

public class TradeIntegrationImpl {
    public static void registerVillagerTrades(Consumer<TradeIntegration.Event> listener) {
        final IEventBus bus = MinecraftForge.EVENT_BUS;
        TradeIntegration.Event integration = new TradeIntegration.Event(){

            @Override
            public void registerTrade(VillagerProfession profession, VillagerLevel level, VillagerTrades.ItemListing ... trades) {
                bus.addListener(event -> {
                    if (event.getType() == profession) {
                        ((List)event.getTrades().computeIfAbsent(level.getValue(), trade -> NonNullList.m_122779_())).addAll(List.of(trades));
                    }
                });
            }

            @Override
            public void registerWandererTrade(boolean rare, VillagerTrades.ItemListing ... trades) {
                bus.addListener(event -> {
                    if (rare) {
                        event.getRareTrades().addAll(List.of(trades));
                    } else {
                        event.getGenericTrades().addAll(List.of(trades));
                    }
                });
            }
        };
        listener.accept(integration);
    }
}

