/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.elysium_api.impl.event;

import java.util.Optional;
import net.jadenxgamer.elysium_api.Elysium;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeHelper;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeSource;
import net.jadenxgamer.elysium_api.impl.surface_rules.ElysiumSurfaceRulesManager;
import net.jadenxgamer.elysium_api.impl.use_behavior.UseBehaviorImpl;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="elysium_api")
public class ElysiumEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        Elysium.registryAccess = event.getServer().m_206579_();
        Elysium.addDataDrivenPossibleBiomes();
        Registry levelStems = Elysium.registryAccess.m_175515_(Registries.f_256862_);
        for (LevelStem dimension : levelStems.m_123024_().toList()) {
            BiomeSource biomeSource;
            Optional dimensionKey = levelStems.m_7854_((Object)dimension);
            if (dimensionKey.isPresent() && (biomeSource = dimension.f_63976_().m_62218_()) instanceof ElysiumBiomeSource) {
                ElysiumBiomeSource biomeSource2 = (ElysiumBiomeSource)biomeSource;
                if (((ResourceKey)dimensionKey.get()).equals((Object)LevelStem.f_63971_)) {
                    biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63971_);
                    biomeSource2.addPossibleBiomes(ElysiumBiomeHelper.overworldPossibleBiomes);
                    biomeSource2.setWorldSeed(event.getServer().m_129910_().m_246337_().m_245499_());
                } else if (((ResourceKey)dimensionKey.get()).equals((Object)LevelStem.f_63972_)) {
                    biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63972_);
                    biomeSource2.addPossibleBiomes(ElysiumBiomeHelper.netherPossibleBiomes);
                    biomeSource2.setWorldSeed(event.getServer().m_129910_().m_246337_().m_245499_());
                }
            }
            ChunkGenerator generator = dimension.f_63976_();
            if (!dimensionKey.isPresent() || !(generator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)generator;
            ElysiumSurfaceRulesManager.handleSurfaceRules((ResourceKey<LevelStem>)((ResourceKey)dimensionKey.get()), noiseGenerator);
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        UseBehaviorImpl.init(event);
    }

    @Mod.EventBusSubscriber(modid="elysium_api", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void commonSetup(FMLCommonSetupEvent event) {
        }
    }
}

