/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jab125.mpuc.Mpuc;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.JavaWorkaround;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OnlineInfo {
    public static final OnlineInfo ERRORED = new ErroredOnlineInfo();
    private static final Gson GSON = new Gson();
    public final Map<String, Version> versions;
    public final String latestVersion;

    private OnlineInfo(Map<String, Version> versions, String latestVersion) {
        this.versions = versions;
        this.latestVersion = latestVersion;
    }

    public static OnlineInfo create(MpucConfig config) {
        try {
            if (MpucConfig.getId((Object)config.type) == 0) {
                return OnlineInfo.createNonAssociated(config);
            }
            if (MpucConfig.getId((Object)config.type) == 1) {
                return config.setAssociatedOnlineInfo(OnlineInfo.create1(config));
            }
            if (MpucConfig.getId((Object)config.type) == 2) {
                return config.setAssociatedOnlineInfo(OnlineInfo.create2(config));
            }
            if (MpucConfig.getId((Object)config.type) == 3) {
                return config.setAssociatedOnlineInfo(OnlineInfo.create3(config));
            }
        }
        catch (Throwable t) {
            System.err.println("[Modpack Update Checker] Error fetching online info!");
            t.printStackTrace();
            return config.setAssociatedOnlineInfo(ERRORED);
        }
        return config.setAssociatedOnlineInfo(ERRORED);
    }

    public static OnlineInfo createNonAssociated(MpucConfig config) {
        NoneOnlineInfo noneOnlineInfo = new NoneOnlineInfo(config);
        config.setAssociatedOnlineInfo(noneOnlineInfo);
        return noneOnlineInfo;
    }

    private static OnlineInfo create1(MpucConfig config) throws IOException, InterruptedException {
        Map<String, Version> map = Collections.synchronizedMap(new LinkedHashMap());
        String githubRepo = config.updateCheckerId;
        JsonObject changelogs = (JsonObject)GSON.fromJson(Mpuc.fetchUrlAsString(githubRepo + "changelogs.json"), JsonObject.class);
        String latestVersion = Mpuc.fetchUrlAsString(githubRepo + "version.txt");
        AtomicInteger integer = new AtomicInteger(0);
        changelogs.entrySet().stream().forEach(set -> {
            String changelog = ((JsonElement)set.getValue()).getAsJsonObject().getAsJsonPrimitive("changelog").getAsString();
            map.put((String)set.getKey(), new Version(integer.getAndIncrement(), (String)set.getKey(), null, new Lazy<String>(() -> changelog), null, null, null));
        });
        return new OnlineInfo(map, latestVersion);
    }

    private static OnlineInfo create2(MpucConfig config) throws IOException, InterruptedException {
        Optional last;
        int protocolVersion;
        Map<String, Version> map = Collections.synchronizedMap(new LinkedHashMap());
        Map map2 = Collections.synchronizedMap(new LinkedHashMap());
        String githubRepo = config.updateCheckerId;
        JsonObject meta = (JsonObject)GSON.fromJson(Mpuc.fetchUrlAsString(githubRepo + "meta.json"), JsonObject.class);
        Meta meta1 = (Meta)GSON.fromJson((JsonElement)meta, Meta.class);
        AtomicInteger integer = new AtomicInteger(0);
        Version currentVersion = null;
        if (!(meta.has("schemaVersion") && meta.get("schemaVersion").isJsonPrimitive() && meta.getAsJsonPrimitive("schemaVersion").isNumber() && meta.getAsJsonPrimitive("schemaVersion").getAsInt() == 1)) {
            throw new IllegalStateException("This version of Modpack Update Checker doesn't support this schema version! Report all issues to " + config.modpackAuthor + "!");
        }
        if (meta.has("requiresMpuc") && meta.get("requiresMpuc").isJsonPrimitive() && (protocolVersion = meta.getAsJsonPrimitive("requiresMpuc").getAsInt()) > 15) {
            throw new IllegalStateException("Protocol version must be less than or equal to 15!");
        }
        if (meta.has("versions") && meta.get("versions").isJsonArray()) {
            JsonArray versions = meta.getAsJsonArray("versions");
            for (JsonElement version : versions) {
                JsonObject v = version.getAsJsonObject();
                String id = v.getAsJsonPrimitive("id").getAsString();
                String updateType = Optional.ofNullable(v.getAsJsonPrimitive("updateType")).map(JsonPrimitive::getAsString).orElse(null);
                UpdateType uTe = null;
                try {
                    uTe = UpdateType.valueOf(updateType.toUpperCase(Locale.ROOT));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Instant releasedAtInstant = null;
                Promotions promotions = OnlineInfo.getPromotions(v);
                if (v.has("releasedAt")) {
                    long releasedAt = v.getAsJsonPrimitive("releasedAt").getAsLong();
                    releasedAtInstant = Instant.ofEpochMilli(releasedAt);
                }
                ArrayList<String> tags = new ArrayList<String>();
                if (v.has("tags")) {
                    v.getAsJsonArray("tags").forEach(q -> tags.add(q.getAsString()));
                }
                Version vf = new Version(integer.getAndIncrement(), id, tags, new Lazy<String>(() -> {
                    try {
                        return Mpuc.fetchUrlAsString((githubRepo + "versions/" + id + "/changelog.txt").replaceAll(" ", "%20"));
                    }
                    catch (IOException | InterruptedException e) {
                        return "Error fetching changelog!";
                    }
                }), releasedAtInstant, promotions, uTe);
                if (config.currentVersion.equals(vf.id)) {
                    currentVersion = vf;
                }
                map.put(id, vf);
            }
        }
        Version cvf = currentVersion;
        List<Map.Entry> filteredStream = JavaWorkaround.Stream$toList(map.entrySet().stream().filter(a -> {
            Instant releaseTime = ((Version)a.getValue()).releaseTime;
            if (cvf != null) {
                Version currentVersion_ = cvf;
                Version toCheckAgainst = (Version)a.getValue();
                if (toCheckAgainst.internalId <= currentVersion_.internalId) {
                    return true;
                }
            }
            if (releaseTime == null) {
                System.out.println("[Modpack Update Checker] Release Time of " + (String)a.getKey() + " was null! Report all issues to " + config.modpackAuthor + "!");
                return true;
            }
            return Instant.now().isAfter(releaseTime);
        }));
        filteredStream.forEach(a -> map2.put((String)a.getKey(), (Version)a.getValue()));
        String latestVersion = Objects.isNull(meta1.latestVersion) ? ((last = filteredStream.stream().filter(a -> config.tags.passes(((Version)a.getValue()).tags)).collect(OnlineInfo.reverse()).findFirst()).isPresent() ? ((Version)((Map.Entry)last.get()).getValue()).id : currentVersion.id) : meta1.latestVersion;
        return new OnlineInfo(map, latestVersion);
    }

    private static OnlineInfo create3(MpucConfig config) throws IOException, InterruptedException {
        String API_PATH = "https://api.modrinth.com/v2/project/%s/version";
        Map<String, Version> map = Collections.synchronizedMap(new LinkedHashMap());
        Map map2 = Collections.synchronizedMap(new LinkedHashMap());
        String modpackId = config.updateCheckerId;
        JsonArray modrinthJson = (JsonArray)GSON.fromJson(Mpuc.fetchUrlAsString(String.format(API_PATH, modpackId)), JsonArray.class);
        AtomicInteger integer = new AtomicInteger(0);
        Version currentVersion = null;
        for (JsonElement version : modrinthJson) {
            JsonObject v = version.getAsJsonObject();
            String vid = v.getAsJsonPrimitive("id").getAsString();
            String id = v.getAsJsonPrimitive("version_number").getAsString();
            Instant releasedAtInstant = null;
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("modrinth", String.format("https://modrinth.com/modpack/%s/version/%s", modpackId, vid));
            Promotions promotions = new Promotions(objectObjectHashMap);
            String releasedAt = v.getAsJsonPrimitive("date_published").getAsString();
            releasedAtInstant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(releasedAt));
            String changelog = v.getAsJsonPrimitive("changelog").getAsString();
            Version vf = new Version(integer.getAndDecrement(), id, Constants.fromModrinth(v), new Lazy<String>(() -> changelog), releasedAtInstant, promotions, null);
            if (config.currentVersion.equals(vf.id)) {
                currentVersion = vf;
            }
            map.put(id, vf);
        }
        Map<String, Version> m = map;
        map = Collections.synchronizedMap(new LinkedHashMap());
        Object[] objects = m.entrySet().toArray();
        for (int i = objects.length - 1; i >= 0; --i) {
            map.put((String)((Map.Entry)objects[i]).getKey(), (Version)((Map.Entry)objects[i]).getValue());
        }
        Version cvf = currentVersion;
        List<Map.Entry> filteredStream = JavaWorkaround.Stream$toList(map.entrySet().stream().filter(a -> {
            Instant releaseTime = ((Version)a.getValue()).releaseTime;
            if (cvf != null) {
                Version currentVersion_ = cvf;
                Version toCheckAgainst = (Version)a.getValue();
                if (toCheckAgainst.internalId <= currentVersion_.internalId) {
                    return true;
                }
            }
            if (releaseTime == null) {
                System.out.println("[Modpack Update Checker] Release Time of " + (String)a.getKey() + " was null! Report all issues to " + config.modpackAuthor + "!");
                return true;
            }
            return Instant.now().isAfter(releaseTime);
        }));
        System.out.println(filteredStream);
        filteredStream.forEach(a -> map2.put((String)a.getKey(), (Version)a.getValue()));
        Optional last = filteredStream.stream().filter(a -> config.tags.passes(((Version)a.getValue()).tags)).collect(OnlineInfo.reverse()).findFirst();
        String latestVersion = last.isPresent() ? ((Version)((Map.Entry)last.get()).getValue()).id : currentVersion.id;
        return new OnlineInfo(map, latestVersion);
    }

    @Nullable
    public static Promotions getPromotions(JsonObject v) {
        if (v.has("promotions")) {
            JsonElement promotions = v.get("promotions");
            if (promotions.isJsonObject()) {
                HashMap<String, String> downloadLinks = new HashMap<String, String>();
                if (promotions.getAsJsonObject().has("downloads") && promotions.getAsJsonObject().get("downloads").isJsonObject()) {
                    JsonObject object = promotions.getAsJsonObject().getAsJsonObject("downloads");
                    for (Map.Entry s : object.entrySet()) {
                        JsonPrimitive asJsonPrimitive;
                        boolean string;
                        JsonElement jsonElement = (JsonElement)s.getValue();
                        if (!jsonElement.isJsonPrimitive() || !(string = (asJsonPrimitive = jsonElement.getAsJsonPrimitive()).isString())) continue;
                        downloadLinks.put((String)s.getKey(), asJsonPrimitive.getAsString());
                    }
                }
                return new Promotions(downloadLinks);
            }
            return null;
        }
        return null;
    }

    public final boolean isErrored() {
        return this == ERRORED;
    }

    public static boolean isErrored(OnlineInfo info) {
        return info == ERRORED;
    }

    public final boolean isDisabled() {
        return this instanceof NoneOnlineInfo;
    }

    public static boolean isDisabled(OnlineInfo info) {
        return info instanceof NoneOnlineInfo;
    }

    public static <T> Collector<T, ?, Stream<T>> reverse() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            Collections.reverse(list);
            return list.stream();
        });
    }

    private static class NoneOnlineInfo
    extends OnlineInfo {
        private NoneOnlineInfo(MpucConfig config) {
            super(NoneOnlineInfo.createMap(config), config.currentVersion);
        }

        private NoneOnlineInfo(Map<String, Version> map, String currentVersion) {
            super(map, currentVersion);
        }

        private static Map<String, Version> createMap(MpucConfig config) {
            HashMap<String, Version> map = new HashMap<String, Version>();
            map.put(config.currentVersion, new Version(0, config.currentVersion, null, new Lazy<String>(() -> ""), Instant.MIN, null, null));
            return map;
        }
    }

    private static class Meta {
        private int schemaVersion;
        private String latestVersion;
        private String hotfixesFormat;

        private Meta() {
        }
    }

    public static enum UpdateType {
        MINOR("mpuc:minor"),
        MINOR_BREAKING("mpuc:minor", "mpuc:minor_breaking", "mpuc:breaking"),
        MAJOR("mpuc:major", "mpuc:breaking"),
        INCOMPATIBLE("mpuc:incompatible");

        private final String[] tags;

        private UpdateType(String ... tags) {
            this.tags = tags;
        }
    }

    public static final class Promotions {
        private final Map<String, String> downloads;

        public Promotions(Map<String, String> downloads) {
            this.downloads = downloads;
        }

        @Nullable
        public String getDownloadLink(String s) {
            return this.downloads.get(s);
        }

        public boolean hasDownloadLinks() {
            return !this.downloads.isEmpty();
        }

        public Optional<String> getDownloadLinkOptional(String s) {
            return Optional.ofNullable(this.getDownloadLink(s));
        }
    }

    public static final class Version {
        public final int internalId;
        public final String id;
        public final List<String> tags;
        private final Lazy<String> changelog;
        @Nullable
        public final Instant releaseTime;
        @Nullable
        public final Promotions promotions;
        @Nullable
        public final UpdateType updateType;

        public Version(int internalId, String id, List<String> tags, Lazy<String> changelog, @Nullable Instant releaseTime, @Nullable Promotions promotions, @Nullable UpdateType updateType) {
            this.internalId = internalId;
            this.id = id;
            ArrayList arrayList = this.tags = tags == null ? new ArrayList() : tags;
            if (updateType != null) {
                this.tags.addAll(Arrays.asList(updateType.tags));
            }
            this.changelog = changelog;
            this.releaseTime = releaseTime;
            this.promotions = promotions;
            this.updateType = updateType;
        }

        public String changelog() {
            return this.changelog.get();
        }
    }

    public static class Lazy<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T obj;

        @Override
        public T get() {
            if (this.obj == null) {
                this.obj = this.supplier.get();
            }
            return this.obj;
        }

        public Lazy(Supplier<T> supplier) {
            this.supplier = supplier;
        }
    }

    private static final class Constants {
        public static final String MODRINTH_MC_VERSION_PREFIX = "builtin:mc/";
        public static final String MODRINTH_MOD_LOADER_PREFIX = "builtin:loader/";

        private Constants() {
        }

        public static List<String> fromModrinth(JsonObject object) {
            boolean hasLoaders = object.has("loaders");
            boolean hasGameVersions = object.has("game_versions");
            ArrayList<String> list = new ArrayList<String>();
            if (hasLoaders) {
                object.getAsJsonArray("loaders").forEach(a -> list.add(MODRINTH_MOD_LOADER_PREFIX + a.getAsString()));
            }
            if (hasGameVersions) {
                object.getAsJsonArray("game_versions").forEach(a -> list.add(MODRINTH_MC_VERSION_PREFIX + a.getAsString()));
            }
            return list;
        }
    }

    private static class ErroredOnlineInfo
    extends NoneOnlineInfo {
        private ErroredOnlineInfo() {
            super(new HashMap<String, Version>(), "Failed to load.");
        }
    }
}

