/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.server;

import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.server.command.MpucCommands;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.OnlineInfo;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class MpucServer {
    public MpucServer() {
        this.onInitializeServer();
    }

    public void onInitializeServer() {
        MpucCommands.register((registryAccess, environment) -> {
            LiteralArgumentBuilder modpack = Commands.m_82127_((String)"modpack");
            LiteralArgumentBuilder show = Commands.m_82127_((String)"show");
            LiteralArgumentBuilder version = Commands.m_82127_((String)"version");
            LiteralArgumentBuilder latest = Commands.m_82127_((String)"latest");
            LiteralArgumentBuilder current = Commands.m_82127_((String)"current");
            Command currentExecutes = context -> {
                MpucServer.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237113_((String)MpucApi.getInstance().getCurrentModpackVersion()));
                return 0;
            };
            Command latestExecutes = context -> {
                MpucServer.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237113_((String)MpucApi.getInstance().getLatestModpackVersion()));
                return 0;
            };
            version.executes(currentExecutes);
            latest.executes(latestExecutes);
            current.executes(currentExecutes);
            version.then((ArgumentBuilder)latest);
            version.then((ArgumentBuilder)current);
            modpack.then((ArgumentBuilder)version);
            RequiredArgumentBuilder changelog = Commands.m_82129_((String)"changelog", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
                for (Map.Entry<String, OnlineInfo.Version> stringVersionEntry : ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.entrySet()) {
                    builder.suggest(stringVersionEntry.getKey());
                }
                return builder.buildFuture();
            });
            LiteralArgumentBuilder changelog2 = Commands.m_82127_((String)"changelog");
            changelog.executes(context -> {
                Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
                String changelogArgument = (String)context.getArgument("changelog", String.class);
                if (versions.containsKey(changelogArgument)) {
                    MpucServer.sendMessage((CommandSourceStack)context.getSource(), ChangelogUtils.fromString(versions.get(changelogArgument).changelog()));
                }
                return 0;
            });
            changelog2.then((ArgumentBuilder)changelog);
            show.then((ArgumentBuilder)changelog2);
            modpack.then((ArgumentBuilder)show);
            return modpack;
        });
        MpucCommands.bootstrap();
    }

    private static void sendMessage(CommandSourceStack source, Component text) {
        source.m_243053_(text);
    }
}

