/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.recipe;

import com.google.common.collect.Lists;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.server.util.BookWriter;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ChangelogBookRecipe
extends CustomRecipe {
    private final Ingredient r = Ingredient.m_43929_((ItemLike[])new ItemLike[0]);
    private final NonNullList<Ingredient> input = NonNullList.m_122783_(null, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42534_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42522_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42534_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}), this.r, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})});

    public ChangelogBookRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        for (int i = 0; i <= inventory.m_39347_() - 3; ++i) {
            for (int j = 0; j <= inventory.m_39346_() - 3; ++j) {
                if (this.matchesPattern(inventory, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack craft(CraftingContainer inventory, RegistryAccess ignored) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!stack.m_150930_(Items.f_42517_)) continue;
            String name = stack.m_41786_().getString();
            Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
            Optional<Map.Entry> version = versions.entrySet().stream().filter(a -> name.equals(((OnlineInfo.Version)a.getValue()).id)).findFirst();
            if (version.isPresent()) {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42615_);
                BookWriter.writeBook(itemStack, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Component[]{Component.m_130674_((String)(MpucApi.getInstance().getModpackName() + " " + ((OnlineInfo.Version)version.get().getValue()).id))}), Lists.newArrayList((Object[])new Component[]{ChangelogUtils.fromString(((OnlineInfo.Version)version.get().getValue()).changelog())})}), MpucApi.getInstance().getModpackName() + " " + ((OnlineInfo.Version)version.get().getValue()).id);
                return itemStack;
            }
            return Items.f_42402_.m_7968_();
        }
        return Items.f_42402_.m_7968_();
    }

    private boolean matchesPattern(CraftingContainer inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < 3 && l < 3) {
                    Ingredient ingredient2 = ingredient = flipped ? (Ingredient)this.input.get(3 - k - 1 + l * 3) : (Ingredient)this.input.get(k + l * 3);
                }
                if (ingredient == this.r) {
                    ItemStack stack = inv.m_8020_(i + j * inv.m_39347_());
                    if (stack.m_150930_(Items.f_42517_) && stack.m_41788_()) {
                        String name = stack.m_41786_().getString();
                        Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
                        if (versions.entrySet().stream().anyMatch(a -> name.equals(((OnlineInfo.Version)a.getValue()).id))) {
                            continue;
                        }
                    }
                } else if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(new ResourceLocation("modpack-update-checker", "changelog_book"));
    }

    public static void register() {
        String id = "changelog_book";
        DeferredRegister deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"modpack-update-checker");
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)deferredRegister);
        deferredRegister.register(id, () -> new SimpleCraftingRecipeSerializer(ChangelogBookRecipe::new));
    }
}

