/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class DateFormatUtil {
    public static MutableComponent format(@Nullable Instant releaseTime) {
        String format;
        VersionStatus status = VersionStatus.getStatus(releaseTime);
        if (status == VersionStatus.TO_BE_ANNOUNCED) {
            return Component.m_237115_((String)"screen.modpack-update-checker.changelog.to-be-announced");
        }
        boolean after = status == VersionStatus.FUTURE_RELEASE_DATE;
        String key = after ? "screen.modpack-update-checker.changelog.releasingOn" : "screen.modpack-update-checker.changelog.releasedAt";
        try {
            format = DateFormatUtil.fromI18n().format(releaseTime);
        }
        catch (Exception e) {
            format = DateFormatUtil.fromI18n().format(LocalDate.from(releaseTime));
        }
        return Component.m_237110_((String)key, (Object[])new Object[]{format});
    }

    public static MutableComponent formatShort(@Nullable Instant releaseTime) {
        String format;
        VersionStatus status = VersionStatus.getStatus(releaseTime);
        if (status == VersionStatus.TO_BE_ANNOUNCED) {
            return Component.m_237113_((String)"TBA");
        }
        if (releaseTime == null) {
            return Component.m_237113_((String)"TBA");
        }
        try {
            format = DateTimeOption.ISO_LOCAL_DATE.formatter.withZone(ZoneId.systemDefault()).format(releaseTime);
        }
        catch (Exception e) {
            try {
                format = DateTimeOption.ISO_LOCAL_DATE.formatter.withZone(ZoneId.systemDefault()).format(LocalDate.from(releaseTime));
            }
            catch (Exception f) {
                format = "ERRPRED";
            }
        }
        return Component.m_237113_((String)format);
    }

    public static DateTimeFormatter fromI18n() {
        String key = "screen.modpack-update-checker.changelog.date-time-format";
        if (!I18n.m_118936_((String)"screen.modpack-update-checker.changelog.date-time-format")) {
            return DateTimeFormatter.ISO_INSTANT;
        }
        String translate = I18n.m_118938_((String)"screen.modpack-update-checker.changelog.date-time-format", (Object[])new Object[0]);
        String opt = translate.toUpperCase(Locale.ROOT);
        try {
            return DateTimeOption.valueOf((String)opt).formatter.withZone(ZoneId.systemDefault());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return DateTimeFormatter.ISO_INSTANT;
        }
    }

    public static enum VersionStatus {
        FUTURE_RELEASE_DATE,
        RELEASED,
        TO_BE_ANNOUNCED;


        public static VersionStatus getStatus(@Nullable Instant releaseTime) {
            return releaseTime == null || releaseTime.equals(Instant.ofEpochMilli(987654321098765L)) ? TO_BE_ANNOUNCED : (releaseTime.isAfter(Instant.now()) ? FUTURE_RELEASE_DATE : RELEASED);
        }
    }

    public static enum DateTimeOption {
        BASIC_ISO_DATE(DateTimeFormatter.BASIC_ISO_DATE),
        ISO_LOCAL_DATE(DateTimeFormatter.ISO_LOCAL_DATE),
        ISO_OFFSET_DATE(DateTimeFormatter.ISO_OFFSET_DATE),
        ISO_DATE(DateTimeFormatter.ISO_DATE),
        ISO_LOCAL_TIME(DateTimeFormatter.ISO_LOCAL_TIME),
        ISO_OFFSET_TIME(DateTimeFormatter.ISO_OFFSET_TIME),
        ISO_TIME(DateTimeFormatter.ISO_TIME),
        ISO_LOCAL_DATE_TIME(DateTimeFormatter.ISO_LOCAL_DATE_TIME),
        ISO_OFFSET_DATE_TIME(DateTimeFormatter.ISO_OFFSET_DATE_TIME),
        ISO_ZONED_DATE_TIME(DateTimeFormatter.ISO_ZONED_DATE_TIME),
        ISO_DATE_TIME(DateTimeFormatter.ISO_DATE_TIME),
        ISO_ORDINAL_DATE(DateTimeFormatter.ISO_ORDINAL_DATE),
        ISO_WEEK_DATE(DateTimeFormatter.ISO_WEEK_DATE),
        ISO_INSTANT(DateTimeFormatter.ISO_INSTANT),
        RFC_1123_DATE_TIME(DateTimeFormatter.RFC_1123_DATE_TIME);

        private final DateTimeFormatter formatter;

        private DateTimeOption(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }
    }
}

