/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import com.jab125.mpuc.client.gui.widget.flow.markdown.WidgetCompiler;
import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;

public class HeaderFeature
implements MarkdownFeature {
    public String name() {
        return "mpuc_header";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof WidgetCompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            String brackets = nibbler.consumeUntilEndOr(c -> c != '#');
            if (!nibbler.tryConsume(' ')) {
                return false;
            }
            tokens.add(new HeaderToken(brackets.length()));
            return true;
        }, '#');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, current, tokens) -> new HeaderNode(current.depth).addChild(parser.parseUntil(tokens, $ -> tokens.peek(-1) instanceof Lexer.NewlineToken || ((Lexer.Token)tokens.peek(-1)).isBoundary() && (!(tokens.peek(-1) instanceof HeaderToken) || ((HeaderToken)((Object)((Object)((Object)tokens.peek((int)-1))))).depth < current.depth), $ -> $ instanceof HeaderToken && ((HeaderToken)$).depth == current.depth)), (token, tokens) -> token instanceof HeaderToken && (tokens.peek(-2) == null || tokens.peek(-2) instanceof Lexer.NewlineToken) ? (HeaderToken)((Object)token) : null);
    }

    private static final class HeaderToken
    extends Lexer.Token {
        public final int depth;

        public HeaderToken(int depth) {
            super("#".repeat(depth) + " ");
            this.depth = depth;
        }

        public boolean isBoundary() {
            return true;
        }
    }

    private static class HeaderNode
    extends Parser.Node {
        private final int depth;

        HeaderNode(int depth) {
            this.depth = depth;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((WidgetCompiler)compiler).visitHeader(this.depth);
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
            ((WidgetCompiler)compiler).visitHeaderEnd(this.depth);
        }
    }
}

