/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.changelog;

import com.jab125.mpuc.client.gui.screen.changelog.ChangelogScreen;
import com.jab125.mpuc.client.gui.screen.changelog.SpecificVersionScreen;
import com.jab125.mpuc.client.util.DateFormatUtil;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.util.OnlineInfo;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;

public class ScrollableChangelogWidget
extends AbstractSelectionList<VersionEntry> {
    private final Font textRenderer;
    private final Map<String, OnlineInfo.Version> versions;

    public ScrollableChangelogWidget(Minecraft client, int width, int height, int top, int bottom) {
        Objects.requireNonNull(client.f_91062_);
        super(client, width, height, top, bottom, 9 * 3 + 12);
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
        for (Map.Entry<String, OnlineInfo.Version> version : this.versions.entrySet()) {
            this.m_239857_(new VersionEntry(version.getValue()));
            this.m_93410_(0.0);
        }
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public class VersionEntry
    extends AbstractSelectionList.Entry<VersionEntry> {
        private final OnlineInfo.Version version;

        public VersionEntry(OnlineInfo.Version version) {
            this.version = version;
        }

        public void m_6311_(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ChatFormatting formatting;
            boolean currentVersion = ConfigInstances.getModpackUpdateCheckerConfig().currentVersion.equals(this.version.id);
            DateFormatUtil.VersionStatus status = DateFormatUtil.VersionStatus.getStatus(this.version.releaseTime);
            ChatFormatting chatFormatting = currentVersion ? ChatFormatting.GREEN : (this.version.id.equals(ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().latestVersion) ? ChatFormatting.YELLOW : (status == DateFormatUtil.VersionStatus.TO_BE_ANNOUNCED ? ChatFormatting.DARK_BLUE : (formatting = status == DateFormatUtil.VersionStatus.FUTURE_RELEASE_DATE ? ChatFormatting.BLUE : ChatFormatting.WHITE)));
            if (hovered) {
                this.fill0(matrices, x, y, x + entryWidth, y + entryHeight, formatting.m_126665_() + -16777216);
                this.fill0(matrices, x + 1, y + 1, x + entryWidth - 1, y + entryHeight - 1, -16777216);
            }
            String changelog = "Click to view changelog.";
            String trimmedChangelog = ScrollableChangelogWidget.this.textRenderer.m_92834_(changelog, entryWidth - 5);
            MutableComponent release = DateFormatUtil.format(this.version.releaseTime);
            Font font = ScrollableChangelogWidget.this.textRenderer;
            MutableComponent mutableComponent = Component.m_237113_((String)this.version.id).m_130940_(formatting);
            int n = x + entryWidth / 2;
            int n2 = y + entryHeight / 4;
            Objects.requireNonNull(ScrollableChangelogWidget.this.textRenderer);
            this.drawCenteredText0(matrices, font, (Component)mutableComponent, n, n2 - 9 / 2, -1);
            Font font2 = ScrollableChangelogWidget.this.textRenderer;
            MutableComponent mutableComponent2 = release.m_130940_(ChatFormatting.GRAY);
            int n3 = x + entryWidth / 2;
            int n4 = y + entryHeight / 4 * 2;
            Objects.requireNonNull(ScrollableChangelogWidget.this.textRenderer);
            this.drawCenteredText0(matrices, font2, (Component)mutableComponent2, n3, n4 - 9 / 2, -1);
            Font font3 = ScrollableChangelogWidget.this.textRenderer;
            MutableComponent mutableComponent3 = Component.m_237113_((String)trimmedChangelog).m_130940_(ChatFormatting.GRAY);
            int n5 = x + entryWidth / 2;
            int n6 = y + entryHeight / 4 * 3;
            Objects.requireNonNull(ScrollableChangelogWidget.this.textRenderer);
            this.drawCenteredText0(matrices, font3, (Component)mutableComponent3, n5, n6 - 9 / 2, -1);
        }

        private void drawCenteredText0(GuiGraphics matrices, Font textRenderer, Component text, int centerX, int y, int color) {
            matrices.m_280653_(textRenderer, text, centerX, y, color);
        }

        private void fill0(GuiGraphics matrices, int x1, int y1, int x2, int y2, int color) {
            matrices.m_280509_(x1, y1, x2, y2, color);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            ScrollableChangelogWidget.this.f_93386_.m_91152_((Screen)new SpecificVersionScreen((ChangelogScreen)Minecraft.m_91087_().f_91080_, this.version, DateFormatUtil.format(this.version.releaseTime)));
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void playDownSound(SoundManager soundManager) {
            soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }
}

