/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget;

import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.ClickEventUtils;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ScrollableGenericTextWidget
extends AbstractSelectionList<TextEntry> {
    private final Font textRenderer;
    private final ArrayList<FormattedCharSequence> textList;
    private String text;

    public ScrollableGenericTextWidget(Minecraft client, int width, int height, int top, int bottom, String text) {
        Objects.requireNonNull(client.f_91062_);
        super(client, width, height, top, bottom, 9);
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.textList = new ArrayList();
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.textList.clear();
        this.m_6702_().clear();
        this.text = text.replaceAll("\r\n", "\n");
        for (FormattedCharSequence s : this.textRenderer.m_92923_((FormattedText)ChangelogUtils.fromString(this.text), this.m_5759_())) {
            this.textList.add(s);
        }
        for (FormattedCharSequence text1 : this.textList) {
            this.m_7085_(new TextEntry(text1));
        }
    }

    private Component parseUrlsAlso(String fff) {
        StringBuilder stringBuilder = new StringBuilder();
        MutableComponent text = Component.m_237119_();
        boolean urlMode = false;
        for (char c : fff.toCharArray()) {
            if (c == '\u03c0') {
                text = text.m_7220_((Component)Component.m_237113_((String)stringBuilder.toString()));
                stringBuilder = new StringBuilder();
                urlMode = true;
                continue;
            }
            if (c == '\u02c6') {
                String q = stringBuilder.toString();
                text = text.m_7220_((Component)Component.m_237113_((String)q).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE).m_131142_(ClickEventUtils.url(q))));
                stringBuilder = new StringBuilder();
                urlMode = false;
                continue;
            }
            stringBuilder.append(c);
        }
        text = text.m_7220_((Component)Component.m_237113_((String)stringBuilder.toString()));
        return text;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public class TextEntry
    extends AbstractSelectionList.Entry<TextEntry> {
        private final FormattedCharSequence text;
        private int textX = -999;

        public TextEntry(FormattedCharSequence text) {
            this.text = text;
        }

        public void m_6311_(GuiGraphics drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.textX = x;
            drawContext.m_280649_(ScrollableGenericTextWidget.this.textRenderer, this.text, this.textX, y, -1, true);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            double f = mouseX - (double)this.textX;
            Style textStyleAt = this.getTextStyleAt(f);
            if (textStyleAt != null) {
                ButtonUtils.handleBasicTextClick(Minecraft.m_91087_().f_91080_, textStyleAt);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        private Style getTextStyleAt(double x) {
            return ScrollableGenericTextWidget.this.textRenderer.m_92865_().m_92338_(this.text, Mth.m_14107_((double)x));
        }
    }
}

