/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MarkdownRenderer;
import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.client.gui.screen.changelog.NewChangelogScreen;
import com.jab125.mpuc.client.gui.screen.legacy4j.Legacy4jButtonAdder;
import com.jab125.mpuc.client.gui.screen.missingmods.MissingModsScreen;
import com.jab125.mpuc.client.gui.widget.flow.markdown.WidgetCompiler;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.integration.FancyMenuV2Integration;
import com.jab125.mpuc.client.integration.FancyMenuV3Integration;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.config.PlatformMods;
import com.jab125.mpuc.util.ClientEvents;
import com.jab125.mpuc.util.Events;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

public class MpucClient {
    private static volatile boolean activatedToast = false;

    public MpucClient() {
        this.onInitializeClient();
    }

    public void onInitializeClient() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ScreenEvent.Init.Post.class, this::registerScreenEvents);
        MpucApi.getInstance().registerMarkdownRenderer("builtin:basic", MarkdownRenderer.BASIC);
        if (Platform.getModList().stream().map(Platform.Mod::getId).anyMatch("mpuc_lavendermd"::equals)) {
            Supplier<Supplier> e = () -> () -> () -> MpucApi.getInstance().registerMarkdownRenderer("builtin:mpuc_lavendermd", (assumedOutputWidth, maxWidth, maxHeight, text, formatting) -> (AbstractWidget)WidgetCompiler.widget(assumedOutputWidth, maxWidth, maxHeight, formatting).process(text));
            ((Runnable)e.get().get()).run();
        }
        Events.CONFIG_RELOADED.subscribe(r -> {
            activatedToast = false;
            MpucClient.addModpackUpdateToast();
        });
        if (Platform.getModList().stream().map(Platform.Mod::getId).anyMatch("legacy"::equals)) {
            new Legacy4jButtonAdder();
        }
        if (Platform.getModList().stream().map(Platform.Mod::getId).anyMatch("fancymenu"::equals) && Platform.getModList().stream().filter(a -> "fancymenu".equals(a.getId())).findFirst().get().getVersion().startsWith("2.")) {
            new FancyMenuV2Integration();
        }
        if (Platform.getModList().stream().map(Platform.Mod::getId).anyMatch("fancymenu"::equals) && Platform.getModList().stream().filter(a -> "fancymenu".equals(a.getId())).findFirst().get().getVersion().startsWith("3.")) {
            new FancyMenuV3Integration();
        }
    }

    private static void forgeMissingMods(Screen screen) {
        boolean missingMods = PlatformMods.hasMissingMods();
        if (missingMods) {
            if (PlatformMods.isAutomatic(ConfigInstances.getPlatformMods())) {
                PlatformMods.autoDownloadMods(ConfigInstances.getPlatformMods());
            }
            if (screen instanceof MissingModsScreen || screen instanceof ConfirmLinkScreen) {
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new MissingModsScreen((Component)Component.m_237113_((String)"Missing Mods!")));
        }
    }

    private static Button createButton(Minecraft client, Screen screen, net.minecraft.client.gui.components.AbstractWidget singleplayerButton) {
        int xOffset = MpucClient.configInstance().buttonXOffset;
        int yOffset = MpucClient.configInstance().buttonYOffset;
        if (MpucClient.configInstance().expandButton) {
            return Button.m_253074_((Component)Component.m_237115_((String)(OnlineInfo.isDisabled(MpucClient.onlineInfo()) ? "button.modpack-update-checker.changelog-button.info" : (Objects.equals(MpucClient.configInstance().currentVersion, MpucClient.onlineInfo().latestVersion) ? "button.modpack-update-checker.changelog-button" : "button.modpack-update-checker.changelog-button.update-available"))), a -> client.m_91152_(MpucClient.createScreen(screen))).m_252987_(singleplayerButton.m_252754_() - 24 + xOffset, singleplayerButton.m_252907_() + yOffset, 200, 20).m_253136_();
        }
        return new ImageButton(singleplayerButton.m_252754_() - 24 + xOffset, singleplayerButton.m_252907_() + yOffset, 20, 20, !Objects.equals(MpucClient.configInstance().currentVersion, MpucClient.onlineInfo().latestVersion) ? 20 : 0, 20, 20, new ResourceLocation("modpack-update-checker", "textures/gui/widgets.png"), 64, 64, btn -> client.m_91152_(MpucClient.createScreen(screen)));
    }

    private static MpucConfig configInstance() {
        return ConfigInstances.getModpackUpdateCheckerConfig();
    }

    private static OnlineInfo onlineInfo() {
        return MpucClient.configInstance().getAssociatedOnlineInfo();
    }

    public static Screen createScreen(Screen previous) {
        return new NewChangelogScreen(previous);
    }

    public static void addModpackUpdateToast() {
        if (PlatformMods.hasMissingMods()) {
            return;
        }
        if (activatedToast) {
            return;
        }
        activatedToast = true;
        if (OnlineInfo.ERRORED == MpucClient.onlineInfo()) {
            return;
        }
        if (OnlineInfo.isDisabled(MpucClient.onlineInfo())) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Minecraft.m_91087_().m_91265_() instanceof LoadingOverlay || !(Minecraft.m_91087_().f_91080_ instanceof TitleScreen)) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                    }
                }
                Minecraft.m_91087_().execute(() -> {
                    if (!Objects.equals(MpucClient.configInstance().currentVersion, MpucClient.onlineInfo().latestVersion)) {
                        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_ACCESS_FAILURE, (Component)Component.m_237115_((String)"toast.modpack-update-checker.modpack-update-available"), (Component)Component.m_237110_((String)"toast.modpack-update-checker.modpack-update-available.description", (Object[])new Object[]{MpucClient.configInstance().currentVersion, MpucClient.onlineInfo().latestVersion})));
                    }
                    if (Hotfixes.hotfixAvailable) {
                        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_ACCESS_FAILURE, (Component)Component.m_237115_((String)"toast.modpack-update-checker.hotfix-available"), (Component)Component.m_237115_((String)"toast.modpack-update-checker.hotfix-available.description")));
                    }
                });
            }
        }).start();
    }

    private void registerScreenEvents(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        Events.invoker(ClientEvents.AFTER_SCREEN_INIT).onInit(screen);
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            MpucClient.addModpackUpdateToast();
            net.minecraft.client.gui.components.AbstractWidget singleplayerButton = null;
            for (Renderable widget : screen.f_169369_) {
                TranslatableContents translatableTextContent;
                net.minecraft.client.gui.components.AbstractWidget button;
                ComponentContents componentContents;
                if (!(widget instanceof net.minecraft.client.gui.components.AbstractWidget) || !((componentContents = (button = (net.minecraft.client.gui.components.AbstractWidget)widget).m_6035_().m_214077_()) instanceof TranslatableContents) || !(translatableTextContent = (TranslatableContents)componentContents).m_237508_().equals("menu.singleplayer")) continue;
                singleplayerButton = button;
                break;
            }
            if (singleplayerButton != null) {
                screen.m_142416_((GuiEventListener)MpucClient.createButton(Minecraft.m_91087_(), screen, singleplayerButton));
            }
        }
    }

    private void registerScreenEvents(ScreenEvent.Init.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            MpucClient.forgeMissingMods(screen);
        }
    }
}

