/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.root;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.zepalesque.redux.util.ArrayUtil;
import net.zepalesque.redux.world.tree.root.ReduxRootPlacers;
import org.apache.commons.lang3.ArrayUtils;

public class BlightwillowRootsPlacer
extends RootPlacer {
    public static final Codec<BlightwillowRootsPlacer> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.f_146531_.fieldOf("trunk_offset_y").forGetter(instance -> instance.f_225860_), (App)Codec.INT.optionalFieldOf("max_root_depth", (Object)2).forGetter(instance -> instance.maxRootDepth), (App)BlockStateProvider.f_68747_.fieldOf("wood").forGetter(instance -> instance.wood)).apply((Applicative)builder, BlightwillowRootsPlacer::new));
    private final int maxRootDepth;
    private final BlockStateProvider wood;
    private static final Direction[] HORIZONTAL_PLANE = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
    private static final Direction[] HORIZONTAL_PLANE_SHUFFLE = (Direction[])HORIZONTAL_PLANE.clone();
    private final Map<BlockPos, Boolean> placements = new HashMap<BlockPos, Boolean>();

    public BlightwillowRootsPlacer(IntProvider trunkOffset, int maxRootDepth, BlockStateProvider wood) {
        super(trunkOffset, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), Optional.empty());
        this.maxRootDepth = maxRootDepth;
        this.wood = wood;
    }

    protected RootPlacerType<?> m_213745_() {
        return (RootPlacerType)ReduxRootPlacers.BLIGHTWILLOW_ROOTS.get();
    }

    public boolean m_213684_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> setter, RandomSource random, BlockPos origin, BlockPos trunkOrigin, TreeConfiguration treeConfig) {
        if (level.m_7433_(origin.m_7495_(), state -> !BlightwillowRootsPlacer.isDirt(state))) {
            return false;
        }
        this.placements.clear();
        ArrayUtil.shuffle(HORIZONTAL_PLANE_SHUFFLE, random);
        int height = trunkOrigin.m_123342_() - origin.m_123342_();
        for (int i = 0; i < height; ++i) {
            this.placements.put(origin.m_6630_(i), false);
        }
        int baseRootHeight = Math.max(height - 5, 2);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            int i;
            int rootSize = baseRootHeight + ArrayUtils.indexOf((Object[])HORIZONTAL_PLANE_SHUFFLE, (Object)d);
            BlockPos rootStart = origin.m_5484_(d, 1);
            int min = 0;
            for (i = -1; i > -2 - this.maxRootDepth; --i) {
                BlockPos test = rootStart.m_6630_(i);
                if (this.validRootPos(level, test)) {
                    if (i >= -this.maxRootDepth) continue;
                    this.unshuffle();
                    return false;
                }
                min = i + 1;
                break;
            }
            for (i = min; i < rootSize; ++i) {
                BlockPos pos2 = rootStart.m_6630_(i);
                if (i < rootSize - 1 && this.validRootPos(level, pos2.m_7494_())) {
                    this.placements.put(pos2, false);
                    continue;
                }
                if (!this.validRootPos(level, pos2)) continue;
                this.placements.put(pos2, true);
            }
        }
        this.unshuffle();
        if (this.validateAll(level, this.placements)) {
            this.placements.forEach((pos, useWood) -> setter.accept((BlockPos)pos, useWood == false ? treeConfig.f_68185_.m_213972_(random, pos) : this.wood.m_213972_(random, pos)));
            TrunkPlacer.m_226169_((LevelSimulatedReader)level, setter, (RandomSource)random, (BlockPos)origin.m_7495_(), (TreeConfiguration)treeConfig);
            return true;
        }
        return false;
    }

    private boolean validateAll(LevelSimulatedReader level, Map<BlockPos, Boolean> placements) {
        for (BlockPos key : placements.keySet()) {
            if (this.validRootPos(level, key)) continue;
            return false;
        }
        return true;
    }

    private void unshuffle() {
        System.arraycopy(HORIZONTAL_PLANE, 0, HORIZONTAL_PLANE_SHUFFLE, 0, HORIZONTAL_PLANE.length);
    }

    protected boolean validRootPos(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_278394_) || state.m_204336_(BlockTags.f_278411_));
    }

    public static boolean isDirt(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_);
    }
}

