/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.natural.skyfields.FieldsprootPetalsBlock;
import net.zepalesque.redux.block.util.state.ReduxStates;
import net.zepalesque.redux.block.util.state.enums.PetalPrismaticness;
import net.zepalesque.redux.util.level.WorldgenUtil;
import org.jetbrains.annotations.Nullable;

public class FieldsprootTreeFeature
extends Feature<Config> {
    public FieldsprootTreeFeature(Codec<Config> codec) {
        super(codec);
    }

    public static boolean m_159759_(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        boolean longerSecondBend;
        WorldGenLevel level = context.m_159774_();
        if (level.m_7433_(context.m_159777_().m_7495_(), state -> !FieldsprootTreeFeature.m_159759_(state))) {
            return false;
        }
        HashMap<BlockPos, BlockState> trunk = new HashMap<BlockPos, BlockState>();
        Direction d = Direction.Plane.HORIZONTAL.m_235690_(context.m_225041_());
        BlockPos foliagePos = this.placeTrunk(context, trunk, d, longerSecondBend = context.m_225041_().m_188499_());
        if (foliagePos == null) {
            return false;
        }
        HashMap<BlockPos, BlockState> foliage = new HashMap<BlockPos, BlockState>();
        if (!this.createFoliage(context, foliage, foliagePos, d, longerSecondBend)) {
            return false;
        }
        for (Map.Entry logEntry : trunk.entrySet()) {
            this.m_5974_((LevelWriter)level, (BlockPos)logEntry.getKey(), (BlockState)logEntry.getValue());
        }
        for (Map.Entry leafEntry : foliage.entrySet()) {
            if (!level.m_7433_((BlockPos)leafEntry.getKey(), state -> !state.m_204336_(BlockTags.f_13106_))) continue;
            this.m_5974_((LevelWriter)level, (BlockPos)leafEntry.getKey(), (BlockState)leafEntry.getValue());
        }
        HashMap petals = Maps.newHashMap();
        this.place(context, petals);
        for (Map.Entry petalEntry : petals.entrySet()) {
            if (!level.m_7433_((BlockPos)petalEntry.getKey(), state -> state.m_60795_()) || !level.m_7433_(((BlockPos)petalEntry.getKey()).m_7495_(), state -> FieldsprootTreeFeature.m_159759_(state))) continue;
            this.m_5974_((LevelWriter)level, (BlockPos)petalEntry.getKey(), (BlockState)petalEntry.getValue());
        }
        return true;
    }

    @Nullable
    public BlockPos placeTrunk(FeaturePlaceContext<Config> context, Map<BlockPos, BlockState> stateMap, Direction d, boolean longerSecondBend) {
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        BlockStateProvider woodProvider = ((Config)context.m_159778_()).woodProvider;
        BlockStateProvider logProvider = ((Config)context.m_159778_()).logProvider;
        int baseHeight = 3 + random.m_188503_(2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int forwards = 2;
        int backwards = forwards + (longerSecondBend ? 1 : 0);
        int top = 3;
        for (int i = 0; i < baseHeight; ++i) {
            mutable.m_122154_((Vec3i)origin, 0, i, 0);
            stateMap.put(mutable.m_7949_(), (i == baseHeight - 1 ? woodProvider : logProvider).m_213972_(random, (BlockPos)mutable));
        }
        BlockPos straightEnd = origin.m_5484_(Direction.UP, baseHeight - 1);
        for (int i = 1; i < forwards; ++i) {
            WorldgenUtil.setWithOffset(mutable, (Vec3i)straightEnd, d, i);
            stateMap.put(mutable.m_7949_(), WorldgenUtil.trySetValue(woodProvider.m_213972_(random, (BlockPos)mutable), RotatedPillarBlock.f_55923_, d.m_122434_()));
            stateMap.put(mutable.m_7949_().m_6630_(2), WorldgenUtil.trySetValue(woodProvider.m_213972_(random, (BlockPos)mutable), RotatedPillarBlock.f_55923_, d.m_122434_()));
        }
        BlockPos edge1 = straightEnd.m_5484_(d, forwards);
        for (int i = 0; i <= 2; ++i) {
            mutable.m_122154_((Vec3i)edge1, 0, i, 0);
            stateMap.put(mutable.m_7949_(), (i == 1 ? logProvider : woodProvider).m_213972_(random, (BlockPos)mutable));
        }
        BlockPos row2Start = straightEnd.m_6630_(2);
        Direction o = d.m_122424_();
        stateMap.put(row2Start, WorldgenUtil.trySetValue(logProvider.m_213972_(random, row2Start), RotatedPillarBlock.f_55923_, d.m_122434_()));
        for (int i = 1; i < backwards; ++i) {
            WorldgenUtil.setWithOffset(mutable, (Vec3i)row2Start, o, i);
            stateMap.put(mutable.m_7949_(), WorldgenUtil.trySetValue(woodProvider.m_213972_(random, (BlockPos)mutable), RotatedPillarBlock.f_55923_, o.m_122434_()));
            stateMap.put(mutable.m_7949_().m_6630_(2), WorldgenUtil.trySetValue(woodProvider.m_213972_(random, (BlockPos)mutable), RotatedPillarBlock.f_55923_, o.m_122434_()));
        }
        BlockPos edge2 = row2Start.m_5484_(o, backwards);
        for (int i = 0; i <= 2; ++i) {
            mutable.m_122154_((Vec3i)edge2, 0, i, 0);
            stateMap.put(mutable.m_7949_(), (i == 1 ? logProvider : woodProvider).m_213972_(random, (BlockPos)mutable));
        }
        BlockPos topStart = row2Start.m_6630_(2);
        for (int i = 0; i < top; ++i) {
            mutable.m_122154_((Vec3i)topStart, 0, i, 0);
            stateMap.put(mutable.m_7949_(), (i == 0 ? woodProvider : logProvider).m_213972_(random, (BlockPos)mutable));
        }
        BlockPos crossStart = topStart.m_7494_();
        for (Direction di : Direction.Plane.HORIZONTAL) {
            if (di == o) continue;
            for (int i = 1; i < 3; ++i) {
                WorldgenUtil.setWithOffset(mutable, (Vec3i)crossStart, di, i);
                stateMap.put(mutable.m_7949_(), WorldgenUtil.trySetValue(logProvider.m_213972_(random, (BlockPos)mutable), RotatedPillarBlock.f_55923_, di.m_122434_()));
            }
        }
        BlockPos absTop = topStart.m_6630_(top);
        WorldGenLevel level = context.m_159774_();
        for (BlockPos pos : stateMap.keySet()) {
            if (this.canPlaceBlockHere((LevelAccessor)level, pos)) continue;
            return null;
        }
        return absTop;
    }

    protected boolean canPlaceBlockHere(LevelAccessor level, BlockPos pos) {
        int i = pos.m_123342_();
        if (i >= level.m_141937_() + 1 && i + 1 < level.m_151558_()) {
            return level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13106_) || state.m_247087_() || state.m_204336_(BlockTags.f_13035_));
        }
        return false;
    }

    public void place(FeaturePlaceContext<Config> context, Map<BlockPos, BlockState> stateMap) {
        Config config = (Config)context.m_159778_();
        int xzSpread = config.patchXZSpread;
        int ySpread = config.patchYSpread;
        int tries = config.patchTries;
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        boolean i = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = xzSpread + 1;
        int k = ySpread + 1;
        for (int l = 0; l < tries; ++l) {
            blockpos$mutableblockpos.m_122154_((Vec3i)origin, random.m_188503_(j) - random.m_188503_(j), random.m_188503_(k) - random.m_188503_(k), random.m_188503_(j) - random.m_188503_(j));
            BlockPos immutable = blockpos$mutableblockpos.m_7949_();
            int p1 = random.m_188503_(7);
            int p2 = random.m_188503_(8) - 1;
            int p3 = p2 == -1 ? -1 : random.m_188503_(8) - 1;
            int p4 = p3 == -1 ? -1 : random.m_188503_(8) - 1;
            int r = (int)(Mth.m_14057_((Vec3i)immutable) % 4L);
            Direction d = r == 0 ? Direction.NORTH : (r == 1 ? Direction.EAST : (r == 2 ? Direction.SOUTH : Direction.EAST));
            BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((FieldsprootPetalsBlock)((Object)ReduxBlocks.FIELDSPROOT_PETALS.get())).m_49966_().m_61124_(ReduxStates.PETAL_1, (Comparable)((Object)PetalPrismaticness.getFromIndex(p1)))).m_61124_(ReduxStates.PETAL_2, (Comparable)((Object)PetalPrismaticness.getFromIndex(p2)))).m_61124_(ReduxStates.PETAL_3, (Comparable)((Object)PetalPrismaticness.getFromIndex(p3)))).m_61124_(ReduxStates.PETAL_4, (Comparable)((Object)PetalPrismaticness.getFromIndex(p4)))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)d);
            stateMap.put(immutable, state);
        }
    }

    protected boolean createFoliage(FeaturePlaceContext<Config> context, Map<BlockPos, BlockState> stateMap, BlockPos origin, Direction d, boolean longerSecondBend) {
        ArrayList toPlace = Lists.newArrayList();
        RandomSource random = context.m_225041_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean corners;
                boolean bl = corners = !(x != 1 && x != -1 || z != 1 && z != -1);
                if (corners && random.m_188503_(3) != 0) continue;
                mutable.m_122154_((Vec3i)origin, x, 0, z);
                toPlace.add(mutable.m_7949_());
            }
        }
        BlockPos layer2 = origin.m_7495_();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int pyth = Mth.m_144944_((int)x) + Mth.m_144944_((int)z);
                if (pyth > 7 && (pyth > 9 || !random.m_188499_())) continue;
                mutable.m_122154_((Vec3i)layer2, x, 0, z);
                toPlace.add(mutable.m_7949_());
            }
        }
        BlockPos layer3 = layer2.m_7495_();
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                int pyth = Mth.m_144944_((int)x) + Mth.m_144944_((int)z);
                if (pyth > 17 && (pyth > 18 || !random.m_188499_())) continue;
                mutable.m_122154_((Vec3i)layer3, x, 0, z);
                toPlace.add(mutable.m_7949_());
            }
        }
        BlockPos layer4 = layer3.m_7495_();
        Direction out = d.m_122428_();
        for (int x = -1; x <= 1; x += 2) {
            for (int z = -1; z <= 1; z += 2) {
                int i;
                boolean longCorners = random.m_188499_();
                for (i = 0; i >= (longCorners ? -1 : 0); --i) {
                    mutable.m_122154_((Vec3i)layer4, x * 2, i, z * 2);
                    toPlace.add(mutable.m_7949_());
                }
                for (i = 0; i >= (longCorners ? 0 : -1); --i) {
                    mutable.m_122154_((Vec3i)layer4, x * (d.m_122434_() == Direction.Axis.X ? 1 : 3), i, z * (d.m_122434_() == Direction.Axis.Z ? 1 : 3));
                    toPlace.add(mutable.m_7949_());
                }
            }
        }
        BlockPos bendVine = layer4.m_5484_(d, 3);
        boolean leaning = random.m_188499_();
        boolean longer = random.m_188499_();
        if (longer) {
            Direction d1 = random.m_188499_() ? out : out.m_122424_();
            mutable.m_122159_((Vec3i)bendVine, d1);
            toPlace.add(mutable.m_7949_());
            if (random.m_188499_()) {
                mutable.m_122159_((Vec3i)bendVine, d1.m_122424_());
                toPlace.add(mutable.m_7949_());
            }
        }
        if (leaning) {
            BlockPos extra = bendVine.m_7495_().m_121945_(d.m_122424_());
            mutable.m_122190_((Vec3i)extra);
            toPlace.add(mutable.m_7949_());
        }
        for (int i = 0; i >= (longer ? -3 : -2); --i) {
            mutable.m_122154_((Vec3i)bendVine, 0, i, 0);
            toPlace.add(mutable.m_7949_());
        }
        BlockPos finalVine = layer4.m_5484_(d.m_122424_(), longerSecondBend ? 4 : 3);
        boolean finalLonger = random.m_188499_();
        if (finalLonger) {
            Direction d1 = random.m_188499_() ? out : out.m_122424_();
            mutable.m_122159_((Vec3i)finalVine, d1);
            toPlace.add(mutable.m_7949_());
            if (random.m_188499_()) {
                mutable.m_122159_((Vec3i)finalVine, d1.m_122424_());
                toPlace.add(mutable.m_7949_());
            }
        }
        for (int i = 0; i >= (finalLonger ? -3 : -2); --i) {
            mutable.m_122154_((Vec3i)finalVine, 0, i, 0);
            toPlace.add(mutable.m_7949_());
        }
        int minY = origin.m_123342_();
        int maxY = origin.m_123342_();
        float maxDist = 0.0f;
        for (BlockPos pos : toPlace) {
            int y = pos.m_123342_();
            if (y > maxY) {
                maxY = y;
            }
            if (y < minY) {
                minY = y;
            }
            int xLocal = pos.m_123341_() - origin.m_123341_();
            int zLocal = pos.m_123343_() - origin.m_123343_();
            float dist = Mth.m_14116_((float)(Mth.m_144944_((int)xLocal) + Mth.m_144944_((int)zLocal)));
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        WorldGenLevel level = context.m_159774_();
        for (BlockPos pos : toPlace) {
            if (!this.canPlaceBlockHere((LevelAccessor)level, pos)) {
                return false;
            }
            stateMap.put(pos, ((Config)context.m_159778_()).leafProvider.m_213972_(random, pos));
        }
        return true;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(mushroom -> mushroom.group((App)BlockStateProvider.f_68747_.fieldOf("leaf_provider").forGetter(config -> config.leafProvider), (App)BlockStateProvider.f_68747_.fieldOf("log_provider").forGetter(config -> config.logProvider), (App)BlockStateProvider.f_68747_.fieldOf("wood_provider").forGetter(config -> config.woodProvider), (App)IntProvider.f_146531_.fieldOf("vine_length").forGetter(config -> config.vineLength), (App)ExtraCodecs.f_144628_.fieldOf("patch_xz_spread").orElse((Object)7).forGetter(patchTreeDecorator -> patchTreeDecorator.patchXZSpread), (App)ExtraCodecs.f_144628_.fieldOf("patch_y_spread").orElse((Object)3).forGetter(patchTreeDecorator -> patchTreeDecorator.patchYSpread), (App)ExtraCodecs.f_144629_.fieldOf("patch_tries").orElse((Object)128).forGetter(patchTreeDecorator -> patchTreeDecorator.patchTries)).apply((Applicative)mushroom, Config::new));
        public final BlockStateProvider leafProvider;
        public final BlockStateProvider logProvider;
        public final BlockStateProvider woodProvider;
        public final IntProvider vineLength;
        public final int patchXZSpread;
        public final int patchYSpread;
        public final int patchTries;

        public Config(BlockStateProvider leafProvider, BlockStateProvider logProvider, BlockStateProvider woodProvider, IntProvider vineLength, int patchXZSpread, int patchYSpread, int patchTries) {
            this.leafProvider = leafProvider;
            this.logProvider = logProvider;
            this.woodProvider = woodProvider;
            this.vineLength = vineLength;
            this.patchXZSpread = patchXZSpread;
            this.patchYSpread = patchYSpread;
            this.patchTries = patchTries;
        }
    }
}

